/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class MarketplaceGui {
    private final EasyShopGUI plugin;
    private final Player player;

    public MarketplaceGui(EasyShopGUI plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&6&l\ud83e\udd16 &e&lAI MARKETPLACE &6&l\ud83e\udd16"));
        this.addMarketOverview(gui);
        this.addTrendingItems(gui);
        this.addAIRecommendations(gui);
        this.addNavigation(gui);
        this.player.openInventory(gui);
    }

    private void addMarketOverview(Inventory gui) {
        gui.setItem(4, new ItemBuilder(Material.EMERALD).setName("&a&l\ud83d\udcca &e&lMARKET OVERVIEW").setLore(Arrays.asList("&7\u25b8 &fAI Engine: &a\u2713 ACTIVE", "&7\u25b8 &fDynamic Pricing: &a\u2713 ENABLED", "&7\u25b8 &fSmart Restocking: &a\u2713 RUNNING", "&7\u25b8 &fMarket Sentiment: &e\ud83d\udcc8 BULLISH", "", "&6&l\ud83e\udd16 AI FEATURES:", "&7\u25b8 &fReal-time price adjustments", "&7\u25b8 &fSupply & demand analysis", "&7\u25b8 &fTrend prediction algorithms", "&7\u25b8 &fAutomatic stock management", "", "&e&l\ud83d\udca1 MARKET INSIGHTS:", "&7\u25b8 &fHigh demand items get price boosts", "&7\u25b8 &fLow stock triggers auto-restocking", "&7\u25b8 &fPrices fluctuate based on activity")).addGlow().build());
    }

    private void addTrendingItems(Inventory gui) {
        List<ShopItem> trendingItems = this.getTrendingItems();
        int[] slots = new int[]{19, 20, 21, 22, 23, 24, 25};
        for (int i = 0; i < Math.min(trendingItems.size(), slots.length); ++i) {
            ShopItem item = trendingItems.get(i);
            double currentPrice = this.plugin.getAiMarketplace().getCurrentBuyPrice(item.getId());
            int currentStock = this.plugin.getAiMarketplace().getCurrentStock(item.getId());
            gui.setItem(slots[i], new ItemBuilder(item.getMaterial()).setName("&6&l\ud83d\udcc8 " + item.getDisplayName()).setLore(Arrays.asList("&7\u25b8 &fCurrent Price: &a$" + String.format("%.2f", currentPrice), "&7\u25b8 &fStock Level: &e" + currentStock, "&7\u25b8 &fTrend: &c\ud83d\udcc8 RISING", "&7\u25b8 &fDemand: &c\ud83d\udd25 HIGH", "", "&e&l\u26a1 AI ANALYSIS:", "&7\u25b8 &fPrice increased by AI", "&7\u25b8 &fHigh trading volume", "&7\u25b8 &fRecommended for investment", "", "&a&l\u27a4 &aClick to view details!")).addGlow().build());
        }
    }

    private void addAIRecommendations(Inventory gui) {
        gui.setItem(40, new ItemBuilder(Material.NETHER_STAR).setName("&d&l\ud83e\udd16 &e&lAI RECOMMENDATIONS").setLore(Arrays.asList("&7\u25b8 &fBased on your trading history", "&7\u25b8 &fMarket analysis algorithms", "&7\u25b8 &fPersonalized suggestions", "", "&d&l\ud83d\udc8e TODAY'S PICKS:", "&7\u25b8 &fDiamonds: &a\ud83d\udcc8 BUY (Rising trend)", "&7\u25b8 &fIron: &e\ud83d\udcca HOLD (Stable)", "&7\u25b8 &fRedstone: &c\ud83d\udcc9 SELL (Declining)", "", "&a&l\u27a4 &aClick for detailed analysis!")).addGlow().build());
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(45, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK TO SHOP").setLore(Arrays.asList("&7\u25b8 &fReturn to main shop", "", "&a&l\u27a4 &aClick to go back!")).build());
        gui.setItem(53, new ItemBuilder(Material.BOOK).setName("&b&l\ud83d\udcca &e&lMARKET ANALYTICS").setLore(Arrays.asList("&7\u25b8 &fDetailed market data", "&7\u25b8 &fPrice history charts", "&7\u25b8 &fTrading volume analysis", "", "&b&l\u27a4 &bClick to view!")).build());
    }

    private List<ShopItem> getTrendingItems() {
        return this.plugin.getGuiManager().getSections().values().stream().flatMap(section -> section.getItems().stream()).limit(7L).collect(Collectors.toList());
    }
}

