/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopGui {
    private final EasyShopGUI plugin;
    private final Player player;
    private final String shopName;

    public ShopGui(EasyShopGUI plugin, Player player, String shopName) {
        this.plugin = plugin;
        this.player = player;
        this.shopName = shopName;
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&6&l\u2726 &e&lEASY SHOP GUI &6&l\u2726"));
        this.fillBackground(gui);
        this.addShopSections(gui);
        this.addNavigationItems(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        int[] borderSlots;
        ItemStack background = new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE).setName(" ").build();
        ItemStack border = new ItemBuilder(Material.YELLOW_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
        for (int slot : borderSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53}) {
            gui.setItem(slot, border);
        }
    }

    private void addShopSections(Inventory gui) {
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        Logger.debug("Adding " + sections.size() + " sections to main shop GUI");
        this.addSectionItem(gui, sections.get("blocks"), 20);
        this.addSectionItem(gui, sections.get("ores"), 22);
        this.addSectionItem(gui, sections.get("food"), 24);
        this.addSectionItem(gui, sections.get("redstone"), 29);
        this.addSectionItem(gui, sections.get("farming"), 31);
        this.addSectionItem(gui, sections.get("decoration"), 33);
        this.addSectionItem(gui, sections.get("potions"), 40);
    }

    private void addSectionItem(Inventory gui, ShopSection section, int slot) {
        if (section == null || !section.isEnabled()) {
            return;
        }
        Logger.debug("Adding section to slot " + slot + ": " + section.getId() + " (" + section.getDisplayName() + ") with " + section.getItems().size() + " items");
        gui.setItem(slot, new ItemBuilder(section.getIcon()).setName(MessageUtils.colorize(section.getDisplayName())).setLore(Arrays.asList("&7\u25b8 &f" + section.getDescription(), "&7\u25b8 &fItems: &a" + section.getItems().size(), "&7\u25b8 &fCategory: &e" + section.getName(), "", "&a&l\u27a4 &aClick to browse!")).addGlow().build());
    }

    private int getSlotForSection(String sectionId) {
        HashMap<String, Integer> defaultSlots = new HashMap<String, Integer>();
        defaultSlots.put("blocks", 10);
        defaultSlots.put("ores", 11);
        defaultSlots.put("food", 12);
        defaultSlots.put("redstone", 13);
        defaultSlots.put("farming", 14);
        defaultSlots.put("decoration", 15);
        defaultSlots.put("potions", 16);
        return defaultSlots.getOrDefault(sectionId, 10);
    }

    private void addNavigationItems(Inventory gui) {
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        gui.setItem(4, new ItemBuilder(Material.PLAYER_HEAD).setName("&6&l\ud83d\udc64 &e&l" + this.player.getName().toUpperCase()).setLore(Arrays.asList("&7\u25b8 &fBalance: &a$" + String.format("%.2f", balance), "&7\u25b8 &fRank: " + (this.player.hasPermission("easyshopgui.vip") ? "&6VIP" : "&7Member"), "&7\u25b8 &fDiscount: &a" + this.getPlayerDiscount(this.player) + "%", "&7\u25b8 &fSell Bonus: &a" + this.getSellMultiplier(this.player) + "x", "", "&6&l\u2b50 &eWelcome to EasyShop!")).setSkullOwner(this.player.getName()).addGlow().build());
        gui.setItem(37, new ItemBuilder(Material.COMPASS).setName("&b&l\ud83d\udd0d &e&lSEARCH ITEMS").setLore(Arrays.asList("&7\u25b8 &fQuickly find items", "&7\u25b8 &fPartial words work", "&7\u25b8 &fTypo-friendly matching", "", "&a&l\u27a4 &aClick to search!")).build());
        gui.setItem(38, new ItemBuilder(Material.BOOK).setName("&3&l\ud83d\udccb &e&lTRANSACTION HISTORY").setLore(Arrays.asList("&7\u25b8 &fView purchase history", "&7\u25b8 &fTrack your spending", "&7\u25b8 &fAnalyze patterns", "", "&a&l\u27a4 &aClick to view!")).build());
        gui.setItem(39, new ItemBuilder(Material.COMPARATOR).setName("&7&l\u2699 &e&lSHOP SETTINGS").setLore(Arrays.asList("&7\u25b8 &fConfirm purchases: &aON", "&7\u25b8 &fSound effects: &aON", "&7\u25b8 &fNotifications: &aON", "&7\u25b8 &fPrice alerts: &cOFF", "", "&a&l\u27a4 &aClick to configure!")).build());
        gui.setItem(41, new ItemBuilder(Material.GOLD_INGOT).setName("&c&l\ud83d\udcb8 &e&lQUICK SELL").setLore(Arrays.asList("&7\u25b8 &fSell items from inventory", "&7\u25b8 &fBulk selling options", "&7\u25b8 &fInstant transactions", "", "&a&l\u27a4 &aClick to sell!")).build());
        gui.setItem(42, new ItemBuilder(Material.PAPER).setName("&e&l\ud83d\udcc4 &e&lSHOP INFORMATION").setLore(Arrays.asList("&7\u25b8 &fShop Name: &a" + this.shopName, "&7\u25b8 &fTotal Items: &a" + this.getTotalItemCount(), "&7\u25b8 &fCategories: &a" + this.plugin.getGuiManager().getSections().size(), "&7\u25b8 &fLast Updated: &aToday", "", "&7\u25b8 &fDynamic Pricing: &aENABLED", "&7\u25b8 &fStock System: &aENABLED")).build());
        gui.setItem(43, new ItemBuilder(Material.BARRIER).setName("&c&l\u2716 &e&lCLOSE SHOP").setLore(Arrays.asList("&7\u25b8 &fClose this menu", "", "&c&l\u27a4 &cClick to close!")).build());
    }

    private int getTotalItemCount() {
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        return sections.values().stream().mapToInt(section -> section.getItems().size()).sum();
    }

    private int getPlayerDiscount(Player player) {
        if (player.hasPermission("easyshopgui.discount.vip")) {
            return 15;
        }
        if (player.hasPermission("easyshopgui.discount.premium")) {
            return 10;
        }
        if (player.hasPermission("easyshopgui.discount.member")) {
            return 5;
        }
        return 0;
    }

    private double getSellMultiplier(Player player) {
        if (player.hasPermission("easyshopgui.multiplier.vip")) {
            return 1.5;
        }
        if (player.hasPermission("easyshopgui.multiplier.premium")) {
            return 1.3;
        }
        if (player.hasPermission("easyshopgui.multiplier.member")) {
            return 1.1;
        }
        return 1.0;
    }
}

