/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.Transaction;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TransactionHistoryGui {
    private final EasyShopGUI plugin;
    private final Player player;
    private int currentPage = 0;
    private final int TRANSACTIONS_PER_PAGE = 7;
    private List<Transaction> transactions = new ArrayList<Transaction>();

    public TransactionHistoryGui(EasyShopGUI plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.loadTransactions();
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&3&l\ud83d\udccb &e&lTRANSACTION HISTORY"));
        this.fillBackground(gui);
        this.addTransactions(gui);
        this.addNavigation(gui);
        this.addStatistics(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        ItemStack background = new ItemBuilder(Material.BLUE_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
    }

    private void loadTransactions() {
        this.transactions = this.plugin.getTransactionManager().getPlayerTransactions(this.player);
    }

    private void addTransactions(Inventory gui) {
        if (this.transactions.isEmpty()) {
            gui.setItem(22, new ItemBuilder(Material.BARRIER).setName("&c&l\u274c &e&lNO TRANSACTIONS").setLore(Arrays.asList("&7\u25b8 &fYou haven't made any transactions yet", "&7\u25b8 &fStart buying or selling items!", "", "&b&l\ud83d\udca1 &bTip: Use /shop to get started!")).build());
            return;
        }
        int startIndex = this.currentPage * 7;
        int[] transactionSlots = new int[]{19, 20, 21, 22, 23, 24, 25};
        for (int i = 0; i < transactionSlots.length && startIndex + i < this.transactions.size(); ++i) {
            Transaction transaction = this.transactions.get(startIndex + i);
            gui.setItem(transactionSlots[i], this.createTransactionItem(transaction, startIndex + i + 1));
        }
    }

    private ItemStack createTransactionItem(Transaction transaction, int number) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        String typeColor = transaction.getType().equals("BUY") ? "&a" : "&c";
        String typeSymbol = transaction.getType().equals("BUY") ? "\ud83d\udcb0" : "\ud83d\udcb8";
        Material displayMaterial = this.getTransactionMaterial(transaction.getItemName());
        return new ItemBuilder(displayMaterial).setName(typeColor + "&l" + typeSymbol + " &e&l#" + number + " - " + transaction.getType()).setLore(Arrays.asList("&7\u25b8 &fItem: &e" + transaction.getItemName(), "&7\u25b8 &fQuantity: &e" + transaction.getQuantity(), "&7\u25b8 &fAmount: " + typeColor + "$" + String.format("%.2f", transaction.getAmount()), "&7\u25b8 &fDate: &7" + dateFormat.format(transaction.getDate()), "&7\u25b8 &fType: " + typeColor + transaction.getType(), "", "&7\u25b8 &fTransaction ID: &8#" + transaction.hashCode())).addGlow(transaction.getType().equals("BUY")).build();
    }

    private Material getTransactionMaterial(String itemName) {
        switch (itemName.toLowerCase()) {
            case "diamond": {
                return Material.DIAMOND;
            }
            case "iron ingot": {
                return Material.IRON_INGOT;
            }
            case "golden apple": {
                return Material.GOLDEN_APPLE;
            }
            case "wheat": {
                return Material.WHEAT;
            }
            case "stone": {
                return Material.STONE;
            }
        }
        return Material.PAPER;
    }

    private void addStatistics(Inventory gui) {
        double totalSpent = this.transactions.stream().filter(t -> t.getType().equals("BUY")).mapToDouble(Transaction::getAmount).sum();
        double totalEarned = this.transactions.stream().filter(t -> t.getType().equals("SELL")).mapToDouble(Transaction::getAmount).sum();
        long buyCount = this.transactions.stream().filter(t -> t.getType().equals("BUY")).count();
        long sellCount = this.transactions.stream().filter(t -> t.getType().equals("SELL")).count();
        gui.setItem(4, new ItemBuilder(Material.EMERALD).setName("&a&l\ud83d\udcca &e&lTRANSACTION STATISTICS").setLore(Arrays.asList("&7\u25b8 &fTotal Transactions: &e" + this.transactions.size(), "&7\u25b8 &fPurchases: &a" + buyCount, "&7\u25b8 &fSales: &c" + sellCount, "", "&7\u25b8 &fTotal Spent: &c$" + String.format("%.2f", totalSpent), "&7\u25b8 &fTotal Earned: &a$" + String.format("%.2f", totalEarned), "&7\u25b8 &fNet Profit: " + (totalEarned - totalSpent >= 0.0 ? "&a" : "&c") + "$" + String.format("%.2f", totalEarned - totalSpent), "", "&7\u25b8 &fPage: &e" + (this.currentPage + 1) + "/" + this.getTotalPages())).addGlow().build());
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(45, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK TO SHOP").setLore(Arrays.asList("&7\u25b8 &fReturn to main shop", "", "&a&l\u27a4 &aClick to go back!")).build());
        if (this.currentPage > 0) {
            gui.setItem(48, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2190 &e&lPREVIOUS PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + this.currentPage + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to go back!")).build());
        }
        if (this.hasNextPage()) {
            gui.setItem(50, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2192 &e&lNEXT PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + (this.currentPage + 2) + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to continue!")).build());
        }
        gui.setItem(46, new ItemBuilder(Material.HOPPER).setName("&b&l\ud83d\udd0d &e&lFILTER OPTIONS").setLore(Arrays.asList("&7\u25b8 &fShow only purchases", "&7\u25b8 &fShow only sales", "&7\u25b8 &fShow all transactions", "", "&b&l\u27a4 &bClick to filter!")).build());
        gui.setItem(49, new ItemBuilder(Material.BOOK).setName("&6&l\ud83d\udcd6 &e&lPAGE INFO").setLore(Arrays.asList("&7\u25b8 &fCurrent Page: &a" + (this.currentPage + 1), "&7\u25b8 &fTotal Pages: &a" + this.getTotalPages(), "&7\u25b8 &fTransactions: &a" + this.transactions.size(), "&7\u25b8 &fShowing: &e" + Math.min(7, this.transactions.size() - this.currentPage * 7))).build());
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.currentPage;
            this.open();
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.open();
        }
    }

    private int getTotalPages() {
        return Math.max(1, (int)Math.ceil((double)this.transactions.size() / 7.0));
    }

    private boolean hasNextPage() {
        return this.currentPage + 1 < this.getTotalPages();
    }
}

