/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.libs.mysql.cj.protocol.a;

import dev.turjo.easyshopgui.libs.mysql.cj.BindValue;
import dev.turjo.easyshopgui.libs.mysql.cj.conf.PropertyKey;
import dev.turjo.easyshopgui.libs.mysql.cj.conf.PropertySet;
import dev.turjo.easyshopgui.libs.mysql.cj.conf.RuntimeProperty;
import dev.turjo.easyshopgui.libs.mysql.cj.exceptions.ExceptionInterceptor;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.Message;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.ServerSession;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.a.AbstractValueEncoder;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.a.NativeConstants;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.a.NativePacketPayload;
import dev.turjo.easyshopgui.libs.mysql.cj.util.StringUtils;
import java.nio.charset.StandardCharsets;

public class ByteArrayValueEncoder
extends AbstractValueEncoder {
    protected RuntimeProperty<Integer> maxByteArrayAsHex;

    @Override
    public void init(PropertySet pset, ServerSession serverSess, ExceptionInterceptor excInterceptor) {
        super.init(pset, serverSess, excInterceptor);
        this.maxByteArrayAsHex = pset.getIntegerProperty(PropertyKey.maxByteArrayAsHex);
    }

    @Override
    public byte[] getBytes(BindValue binding) {
        if (binding.escapeBytesIfNeeded()) {
            return this.escapeBytesIfNeeded((byte[])binding.getValue());
        }
        return (byte[])binding.getValue();
    }

    @Override
    public String getString(BindValue binding) {
        if (binding.escapeBytesIfNeeded() && binding.getBinaryLength() <= (long)this.maxByteArrayAsHex.getValue().intValue()) {
            return StringUtils.toString(this.escapeBytesIfNeeded((byte[])binding.getValue()), StandardCharsets.US_ASCII);
        }
        return "** BYTE ARRAY DATA **";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        ((NativePacketPayload)msg).writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, (byte[])binding.getValue());
    }
}

