/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.libs.mysql.cj.protocol.a;

import dev.turjo.easyshopgui.libs.mysql.cj.Messages;
import dev.turjo.easyshopgui.libs.mysql.cj.ServerVersion;
import dev.turjo.easyshopgui.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.turjo.easyshopgui.libs.mysql.cj.exceptions.UnableToConnectException;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.ServerCapabilities;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.a.NativeConstants;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.a.NativePacketPayload;

public class NativeCapabilities
implements ServerCapabilities {
    private NativePacketPayload initialHandshakePacket;
    private byte protocolVersion = 0;
    private ServerVersion serverVersion;
    private long threadId = -1L;
    private String seed;
    private int capabilityFlags;
    private int serverDefaultCollationIndex;
    private int statusFlags = 0;
    private int authPluginDataLength = 0;
    private boolean serverHasFracSecsSupport = true;

    public NativeCapabilities(NativePacketPayload initialHandshakePacket) {
        this.initialHandshakePacket = initialHandshakePacket;
        this.protocolVersion = (byte)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT1);
        try {
            this.serverVersion = ServerVersion.parseVersion(initialHandshakePacket.readString(NativeConstants.StringSelfDataType.STRING_TERM, "ASCII"));
            this.threadId = initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT4);
            this.seed = initialHandshakePacket.readString(NativeConstants.StringLengthDataType.STRING_FIXED, "ASCII", 8);
            initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT1);
            int flags = 0;
            if (initialHandshakePacket.getPosition() < initialHandshakePacket.getPayloadLength()) {
                flags = (int)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT2);
            }
            this.serverDefaultCollationIndex = (int)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT1);
            this.statusFlags = (int)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT2);
            this.setCapabilityFlags(flags |= (int)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT2) << 16);
            if ((flags & 0x80000) != 0) {
                this.authPluginDataLength = (int)initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT1);
            } else {
                initialHandshakePacket.readInteger(NativeConstants.IntegerDataType.INT1);
            }
            initialHandshakePacket.setPosition(initialHandshakePacket.getPosition() + 10);
            this.serverHasFracSecsSupport = this.serverVersion.meetsMinimum(new ServerVersion(5, 6, 4));
        }
        catch (Throwable t) {
            if (this.protocolVersion == 11 && IndexOutOfBoundsException.class.isAssignableFrom(t.getClass())) {
                throw ExceptionFactory.createException(UnableToConnectException.class, Messages.getString("NativeCapabilites.001", new Object[]{this.protocolVersion}));
            }
            throw t;
        }
    }

    public NativePacketPayload getInitialHandshakePacket() {
        return this.initialHandshakePacket;
    }

    @Override
    public int getCapabilityFlags() {
        return this.capabilityFlags;
    }

    @Override
    public void setCapabilityFlags(int capabilityFlags) {
        this.capabilityFlags = capabilityFlags;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public String getSeed() {
        return this.seed;
    }

    @Override
    public int getServerDefaultCollationIndex() {
        return this.serverDefaultCollationIndex;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public int getAuthPluginDataLength() {
        return this.authPluginDataLength;
    }

    @Override
    public boolean serverSupportsFracSecs() {
        return this.serverHasFracSecsSupport;
    }
}

