/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.libs.mysql.cj.xdevapi;

import dev.turjo.easyshopgui.libs.mysql.cj.MysqlxSession;
import dev.turjo.easyshopgui.libs.mysql.cj.conf.PropertySet;
import dev.turjo.easyshopgui.libs.mysql.cj.exceptions.ExceptionFactory;
import dev.turjo.easyshopgui.libs.mysql.cj.exceptions.WrongArgumentException;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.ColumnDefinition;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.ProtocolEntity;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.ResultBuilder;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.x.FetchDoneEntity;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.x.Notice;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.x.StatementExecuteOk;
import dev.turjo.easyshopgui.libs.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import dev.turjo.easyshopgui.libs.mysql.cj.result.BufferedRowList;
import dev.turjo.easyshopgui.libs.mysql.cj.result.DefaultColumnDefinition;
import dev.turjo.easyshopgui.libs.mysql.cj.result.Field;
import dev.turjo.easyshopgui.libs.mysql.cj.result.Row;
import dev.turjo.easyshopgui.libs.mysql.cj.xdevapi.RowResult;
import dev.turjo.easyshopgui.libs.mysql.cj.xdevapi.RowResultImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class RowResultBuilder
implements ResultBuilder<RowResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private RowResult result;
    TimeZone defaultTimeZone;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public RowResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public RowResult build() {
        if (this.metadata == null) {
            this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
        }
        this.result = new RowResultImpl(this.metadata, this.defaultTimeZone, new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

