/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.listeners;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.gui.QuickSellGui;
import dev.turjo.easyshopgui.gui.SearchGui;
import dev.turjo.easyshopgui.gui.SectionGui;
import dev.turjo.easyshopgui.gui.ShopSettingsGui;
import dev.turjo.easyshopgui.gui.TransactionHistoryGui;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class GuiListener
implements Listener {
    private final EasyShopGUI plugin;
    private final Map<Player, String> playerCurrentSection = new HashMap<Player, String>();
    private final Map<Player, Integer> playerCurrentPage = new HashMap<Player, Integer>();
    private final Map<Player, Long> lastClickTime = new HashMap<Player, Long>();
    private final Map<Player, Boolean> waitingForSearch = new HashMap<Player, Boolean>();
    private final Map<Player, SearchGui> activeSearchGuis = new HashMap<Player, SearchGui>();
    private final Map<Player, QuickSellGui> activeQuickSellGuis = new HashMap<Player, QuickSellGui>();
    private final Map<Player, TransactionHistoryGui> activeTransactionGuis = new HashMap<Player, TransactionHistoryGui>();
    private final Map<Player, SectionGui> activeSectionGuis = new HashMap<Player, SectionGui>();

    public GuiListener(EasyShopGUI plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = MessageUtils.stripColor(event.getView().getTitle());
        Logger.debug("GUI Click Event - Title: " + title + ", Slot: " + event.getSlot() + ", Click: " + String.valueOf(event.getClick()));
        if (this.isShopGUI(title)) {
            if (title.contains("QUICK SELL")) {
                this.handleQuickSellGUIClick(event, player, title);
                return;
            }
            event.setCancelled(true);
            Logger.debug("Shop GUI detected, cancelling event: " + title);
            long currentTime = System.currentTimeMillis();
            if (this.lastClickTime.containsKey(player) && currentTime - this.lastClickTime.get(player) < 100L) {
                Logger.debug("Click spam detected, ignoring");
                return;
            }
            this.lastClickTime.put(player, currentTime);
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                Logger.debug("Clicked item is null or air, ignoring");
                return;
            }
            ItemMeta meta = clickedItem.getItemMeta();
            if (meta == null) {
                Logger.debug("Item meta is null, ignoring");
                return;
            }
            String itemName = meta.getDisplayName() != null ? MessageUtils.stripColor(meta.getDisplayName()) : "";
            Logger.debug("Processing click on item: " + itemName + " in GUI: " + title);
            if (title.contains("EASY SHOP GUI")) {
                this.handleMainShopClick(player, itemName, clickedItem.getType(), event.getSlot());
            } else if (title.contains("SEARCH ITEMS")) {
                this.handleSearchClick(player, itemName, event.getClick(), clickedItem);
            } else if (title.contains("TRANSACTION HISTORY")) {
                this.handleTransactionHistoryClick(player, itemName, event.getSlot());
            } else if (title.contains("SECTION") || title.contains("BLOCKS") || title.contains("ORES") || title.contains("FOOD") || title.contains("REDSTONE") || title.contains("FARMING") || title.contains("DECORATION")) {
                this.handleSectionClick(player, itemName, event.getClick(), clickedItem, event.getSlot());
            }
        }
    }

    private void handleQuickSellGUIClick(InventoryClickEvent event, Player player, String title) {
        event.setCancelled(true);
        QuickSellGui quickSellGui = this.activeQuickSellGuis.get(player);
        if (quickSellGui == null) {
            Logger.debug("No active QuickSell GUI found for player: " + player.getName());
            return;
        }
        int slot = event.getSlot();
        ItemStack clickedItem = event.getCurrentItem();
        String itemName = "";
        if (clickedItem != null && clickedItem.getItemMeta() != null) {
            itemName = MessageUtils.stripColor(clickedItem.getItemMeta().getDisplayName());
        }
        Logger.debug("QuickSell GUI click - Slot: " + slot + ", Item: " + itemName);
        if (quickSellGui.isSellSlot(slot)) {
            Logger.debug("Sell slot clicked, allowing interaction: " + slot);
            event.setCancelled(false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.getOpenInventory() != null) {
                    quickSellGui.updateValueDisplay(player.getOpenInventory().getTopInventory());
                }
            }, 1L);
            return;
        }
        if (itemName.contains("SELL ALL ITEMS") && slot == 49) {
            Logger.debug("Sell All button clicked");
            quickSellGui.sellAllItems(player.getOpenInventory().getTopInventory());
            this.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
        } else if (itemName.contains("CLEAR ALL ITEMS") && slot == 47) {
            Logger.debug("Clear All button clicked");
            quickSellGui.clearAllItems(player.getOpenInventory().getTopInventory());
            this.playSound(player, Sound.ENTITY_ITEM_PICKUP);
        } else if (itemName.contains("AUTO-FILL FROM INVENTORY") && slot == 51) {
            Logger.debug("Auto-Fill button clicked");
            quickSellGui.autoFillFromInventory(player.getOpenInventory().getTopInventory());
            this.playSound(player, Sound.ENTITY_ITEM_PICKUP);
        } else if (itemName.contains("BACK TO SHOP") && slot == 45) {
            Logger.debug("Back button clicked in QuickSell");
            this.activeQuickSellGuis.remove(player);
            this.plugin.getGuiManager().openShop(player, "main");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        } else {
            Logger.debug("Unhandled QuickSell click - Slot: " + slot + ", Item: " + itemName);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = MessageUtils.stripColor(event.getView().getTitle());
        if (title.contains("QUICK SELL")) {
            QuickSellGui quickSellGui = this.activeQuickSellGuis.get(player);
            if (quickSellGui != null) {
                boolean onlySellSlots = event.getRawSlots().stream().allMatch(slot -> slot >= event.getView().getTopInventory().getSize() || quickSellGui.isSellSlot((int)slot));
                if (!onlySellSlots) {
                    event.setCancelled(true);
                    Logger.debug("Drag event cancelled - involves non-sell slots");
                } else {
                    Logger.debug("Drag event allowed in sell slots");
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        if (player.getOpenInventory() != null) {
                            quickSellGui.updateValueDisplay(player.getOpenInventory().getTopInventory());
                        }
                    }, 1L);
                }
            }
            return;
        }
        if (this.isShopGUI(title)) {
            event.setCancelled(true);
            Logger.debug("Drag event cancelled in shop GUI: " + title);
        }
    }

    private boolean isShopGUI(String title) {
        return title.contains("EASY SHOP GUI") || title.contains("SECTION") || title.contains("SEARCH ITEMS") || title.contains("QUICK SELL") || title.contains("BLOCKS") || title.contains("ORES") || title.contains("FOOD") || title.contains("REDSTONE") || title.contains("FARMING") || title.contains("DECORATION") || title.contains("TRANSACTION HISTORY") || title.contains("SHOP SETTINGS");
    }

    private void handleMainShopClick(Player player, String itemName, Material material, int slot) {
        Logger.debug("Main shop click - Slot: " + slot + ", Item: " + itemName);
        switch (slot) {
            case 20: {
                this.openSection(player, "blocks");
                break;
            }
            case 22: {
                this.openSection(player, "ores");
                break;
            }
            case 24: {
                this.openSection(player, "food");
                break;
            }
            case 29: {
                this.openSection(player, "redstone");
                break;
            }
            case 31: {
                this.openSection(player, "farming");
                break;
            }
            case 33: {
                this.openSection(player, "decoration");
                break;
            }
            case 37: {
                this.openSearchGUI(player);
                break;
            }
            case 38: {
                this.openTransactionHistory(player);
                break;
            }
            case 39: {
                this.openSettings(player);
                break;
            }
            case 41: {
                this.openQuickSell(player);
                break;
            }
            case 42: {
                this.playSound(player, Sound.UI_BUTTON_CLICK);
                break;
            }
            case 43: {
                player.closeInventory();
                this.playSound(player, Sound.UI_BUTTON_CLICK);
                break;
            }
            default: {
                Logger.debug("Unhandled slot click: " + slot);
            }
        }
    }

    private void handleSectionClick(Player player, String itemName, ClickType clickType, ItemStack clickedItem, int slot) {
        Logger.debug("Section click - Item: " + itemName + ", Click: " + String.valueOf(clickType) + ", Slot: " + slot);
        if (slot == 0 || itemName.contains("BACK")) {
            Logger.debug("Back button clicked, opening main shop");
            this.plugin.getGuiManager().openShop(player, "main");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
            return;
        }
        if (slot == 45 || itemName.contains("PREVIOUS PAGE")) {
            this.handlePreviousPage(player);
            this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            return;
        }
        if (slot == 53 || itemName.contains("NEXT PAGE")) {
            this.handleNextPage(player);
            this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            return;
        }
        if (this.isNavigationItem(itemName, clickedItem, slot)) {
            Logger.debug("Navigation item clicked, ignoring: " + itemName);
            return;
        }
        String sectionId = this.playerCurrentSection.get(player);
        if (sectionId != null) {
            ShopSection section = this.plugin.getGuiManager().getSections().get(sectionId);
            if (section != null) {
                ShopItem shopItem = section.getItems().stream().filter(item -> item.getMaterial() == clickedItem.getType()).findFirst().orElse(null);
                if (shopItem != null) {
                    Logger.debug("Found shop item: " + shopItem.getId() + " for transaction");
                    this.handleItemTransaction(player, shopItem, clickType);
                } else {
                    Logger.debug("No shop item found for material: " + String.valueOf(clickedItem.getType()));
                    player.sendMessage("\u00a7cThis item is not available for purchase!");
                }
            } else {
                Logger.debug("Section not found: " + sectionId);
            }
        } else {
            Logger.debug("No section ID found for player: " + player.getName());
        }
    }

    private void handleSearchClick(Player player, String itemName, ClickType clickType, ItemStack clickedItem) {
        SearchGui searchGui = this.activeSearchGuis.get(player);
        if (itemName.contains("BACK TO SHOP")) {
            this.activeSearchGuis.remove(player);
            this.waitingForSearch.remove(player);
            this.plugin.getGuiManager().openShop(player, "main");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        } else if (itemName.contains("CLEAR SEARCH")) {
            if (searchGui != null) {
                searchGui.clearSearch();
                this.playSound(player, Sound.UI_BUTTON_CLICK);
            }
        } else if (itemName.contains("PREVIOUS PAGE")) {
            if (searchGui != null) {
                searchGui.previousPage();
                this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            }
        } else if (itemName.contains("NEXT PAGE")) {
            if (searchGui != null) {
                searchGui.nextPage();
                this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            }
        } else if (itemName.contains("SMART SEARCH")) {
            this.waitingForSearch.put(player, true);
            player.closeInventory();
            player.sendMessage("\u00a7b\ud83d\udd0d Type your search query in chat! (Type 'cancel' to cancel)");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        } else if (itemName.contains("POPULAR: DIAMONDS")) {
            if (searchGui != null) {
                searchGui.quickSearch("diamond");
                this.playSound(player, Sound.UI_BUTTON_CLICK);
            }
        } else if (itemName.contains("POPULAR: IRON")) {
            if (searchGui != null) {
                searchGui.quickSearch("iron");
                this.playSound(player, Sound.UI_BUTTON_CLICK);
            }
        } else if (itemName.contains("POPULAR: FOOD")) {
            if (searchGui != null) {
                searchGui.quickSearch("food");
                this.playSound(player, Sound.UI_BUTTON_CLICK);
            }
        } else if (itemName.contains("POPULAR: REDSTONE")) {
            if (searchGui != null) {
                searchGui.quickSearch("redstone");
                this.playSound(player, Sound.UI_BUTTON_CLICK);
            }
        } else if (!this.isNavigationItem(itemName, clickedItem, -1) && searchGui != null && !searchGui.getSearchResults().isEmpty()) {
            ShopItem foundItem = searchGui.getSearchResults().stream().filter(item -> item.getMaterial() == clickedItem.getType()).findFirst().orElse(null);
            if (foundItem != null) {
                Logger.debug("Processing transaction from search for: " + foundItem.getId());
                this.handleItemTransactionFromSearch(player, foundItem, clickType, searchGui);
            } else {
                Logger.debug("No matching item found in search results for: " + String.valueOf(clickedItem.getType()));
            }
        }
    }

    private void handleTransactionHistoryClick(Player player, String itemName, int slot) {
        TransactionHistoryGui historyGui = this.activeTransactionGuis.get(player);
        Logger.debug("Transaction history click - Item: " + itemName + ", Slot: " + slot);
        if (itemName.contains("BACK TO SHOP") && slot == 45) {
            this.activeTransactionGuis.remove(player);
            this.plugin.getGuiManager().openShop(player, "main");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        } else if (itemName.contains("PREVIOUS PAGE") && slot == 48) {
            if (historyGui != null) {
                historyGui.previousPage();
                this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            }
        } else if (itemName.contains("NEXT PAGE") && slot == 50) {
            if (historyGui != null) {
                historyGui.nextPage();
                this.playSound(player, Sound.ITEM_BOOK_PAGE_TURN);
            }
        } else if (itemName.contains("FILTER OPTIONS") && slot == 46) {
            player.sendMessage("\u00a7e\ud83d\udd0d Filter options coming soon!");
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        }
    }

    private boolean isNavigationItem(String itemName, ItemStack item, int slot) {
        if (slot == 0 || slot == 4 || slot == 8 || slot == 9 || slot == 17 || slot == 18 || slot == 26 || slot == 27 || slot == 35 || slot == 36 || slot == 44 || slot == 45 || slot == 46 || slot == 47 || slot == 48 || slot == 49 || slot == 50 || slot == 51 || slot == 52 || slot == 53) {
            return true;
        }
        Material material = item.getType();
        if (material == Material.BLACK_STAINED_GLASS_PANE || material == Material.GRAY_STAINED_GLASS_PANE || material == Material.BLUE_STAINED_GLASS_PANE || material == Material.RED_STAINED_GLASS_PANE || material == Material.YELLOW_STAINED_GLASS_PANE || material == Material.CYAN_STAINED_GLASS_PANE || material == Material.GREEN_STAINED_GLASS_PANE || material == Material.PURPLE_STAINED_GLASS_PANE || material == Material.PINK_STAINED_GLASS_PANE || material == Material.LIGHT_BLUE_STAINED_GLASS_PANE || material == Material.LIGHT_GRAY_STAINED_GLASS_PANE || material == Material.LIME_STAINED_GLASS_PANE || material == Material.MAGENTA_STAINED_GLASS_PANE || material == Material.ORANGE_STAINED_GLASS_PANE || material == Material.WHITE_STAINED_GLASS_PANE || material == Material.SPECTRAL_ARROW || material == Material.ARROW || material == Material.BOOK || material == Material.KNOWLEDGE_BOOK || material == Material.EMERALD || material == Material.COMPASS || material == Material.HOPPER || material == Material.COMPARATOR || material == Material.PAPER || material == Material.BARRIER || material == Material.PLAYER_HEAD) {
            return true;
        }
        return itemName.contains("PAGE INFO") || itemName.contains("PLAYER") || itemName.contains("QUICK ACTIONS") || itemName.contains("BACK") || itemName.contains("PREVIOUS") || itemName.contains("NEXT") || itemName.contains("SEARCH") || itemName.contains("HISTORY") || itemName.contains("SETTINGS") || itemName.contains("INFORMATION") || itemName.contains("CLOSE") || itemName.contains("TIPS") || itemName.contains("STATISTICS") || itemName.contains("HOW TO USE") || itemName.contains("TOTAL VALUE") || itemName.contains("SELL ALL") || itemName.contains("CLEAR ALL") || itemName.contains("AUTO-FILL");
    }

    private void handleItemTransaction(Player player, ShopItem shopItem, ClickType clickType) {
        Logger.debug("Handling transaction - Item: " + shopItem.getId() + ", Click: " + String.valueOf(clickType));
        switch (clickType) {
            case LEFT: {
                this.buyItem(player, shopItem, 1);
                break;
            }
            case RIGHT: {
                this.sellItem(player, shopItem, 1);
                break;
            }
            case SHIFT_LEFT: {
                this.buyItem(player, shopItem, 64);
                break;
            }
            case SHIFT_RIGHT: {
                this.sellAllItems(player, shopItem);
                break;
            }
            case MIDDLE: {
                String sectionId = this.playerCurrentSection.get(player);
                if (sectionId == null) break;
                this.plugin.getGuiManager().openItemDetail(player, sectionId, shopItem.getId());
                break;
            }
            default: {
                Logger.debug("Unhandled click type: " + String.valueOf(clickType));
            }
        }
    }

    private void buyItem(Player player, ShopItem item, int amount) {
        Logger.debug("Attempting to buy " + amount + "x " + item.getId());
        if (item.getStock() != -1 && item.getStock() < amount) {
            player.sendMessage("\u00a7c\ud83d\udce6 Not enough stock! Available: " + item.getStock() + ", Requested: " + amount);
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
            return;
        }
        double currentPrice = this.plugin.getAiMarketplace().getCurrentBuyPrice(item.getId());
        if (currentPrice <= 0.0) {
            currentPrice = item.getBuyPrice();
        }
        double totalPrice = currentPrice * (double)amount;
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)player);
        Logger.debug("Price: $" + totalPrice + ", Balance: $" + balance);
        if (balance < totalPrice) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Insufficient funds! Need $" + String.format("%.2f", totalPrice) + " but only have $" + String.format("%.2f", balance));
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
            return;
        }
        if (!this.hasInventorySpace(player, amount)) {
            player.sendMessage("\u00a7c\ud83d\udce6 Not enough inventory space!");
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
            return;
        }
        try {
            this.plugin.getEconomyManager().getEconomy().withdrawPlayer((OfflinePlayer)player, totalPrice);
            ItemStack itemToGive = new ItemStack(item.getMaterial(), amount);
            player.getInventory().addItem(new ItemStack[]{itemToGive});
            if (item.getStock() != -1) {
                item.setStock(Math.max(0, item.getStock() - amount));
            }
            this.plugin.getAiMarketplace().recordTransaction(item.getId(), "BUY", amount, totalPrice);
            this.plugin.getTransactionManager().recordTransaction(player, "BUY", item.getDisplayName(), amount, totalPrice);
            player.sendMessage("\u00a7a\ud83d\udcb0 Successfully purchased " + amount + "x " + MessageUtils.stripColor(item.getDisplayName()) + " \u00a7afor \u00a76$" + String.format("%.2f", totalPrice) + "!");
            this.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
            Logger.debug("Purchase successful: " + amount + "x " + item.getId());
            this.refreshCurrentGUI(player);
        }
        catch (Exception e) {
            Logger.error("Error during purchase: " + e.getMessage());
            player.sendMessage("\u00a7cError during purchase! Please try again.");
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
        }
    }

    private void sellItem(Player player, ShopItem item, int amount) {
        Logger.debug("Attempting to sell " + amount + "x " + item.getId());
        int playerItemCount = this.getPlayerItemCount(player, item.getMaterial());
        if (playerItemCount < amount) {
            player.sendMessage("\u00a7c\ud83d\udce6 You don't have enough " + MessageUtils.stripColor(item.getDisplayName()) + "! Have " + playerItemCount + ", need " + amount);
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
            return;
        }
        double currentPrice = this.plugin.getAiMarketplace().getCurrentSellPrice(item.getId());
        if (currentPrice <= 0.0) {
            currentPrice = item.getSellPrice();
        }
        double totalPrice = currentPrice * (double)amount;
        try {
            this.removeItemsFromInventory(player, item.getMaterial(), amount);
            this.plugin.getEconomyManager().getEconomy().depositPlayer((OfflinePlayer)player, totalPrice);
            this.plugin.getAiMarketplace().recordTransaction(item.getId(), "SELL", amount, totalPrice);
            this.plugin.getTransactionManager().recordTransaction(player, "SELL", item.getDisplayName(), amount, totalPrice);
            player.sendMessage("\u00a76\ud83d\udcb8 Successfully sold " + amount + "x " + MessageUtils.stripColor(item.getDisplayName()) + " \u00a76for \u00a7a$" + String.format("%.2f", totalPrice) + "!");
            this.playSound(player, Sound.ENTITY_VILLAGER_YES);
            Logger.debug("Sale successful: " + amount + "x " + item.getId());
            this.refreshCurrentGUI(player);
        }
        catch (Exception e) {
            Logger.error("Error during sale: " + e.getMessage());
            player.sendMessage("\u00a7cError during sale! Please try again.");
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
        }
    }

    private void sellAllItems(Player player, ShopItem item) {
        int playerItemCount = this.getPlayerItemCount(player, item.getMaterial());
        if (playerItemCount > 0) {
            this.sellItem(player, item, playerItemCount);
        } else {
            player.sendMessage("\u00a7c\ud83d\udce6 You don't have any " + MessageUtils.stripColor(item.getDisplayName()) + " to sell!");
            this.playSound(player, Sound.ENTITY_VILLAGER_NO);
        }
    }

    private void openSection(Player player, String sectionId) {
        Logger.debug("Opening section: " + sectionId + " for player: " + player.getName());
        this.playerCurrentSection.put(player, sectionId);
        this.playerCurrentPage.put(player, 0);
        ShopSection section = this.plugin.getGuiManager().getSections().get(sectionId);
        if (section != null) {
            SectionGui sectionGui = new SectionGui(this.plugin, player, section);
            this.activeSectionGuis.put(player, sectionGui);
            sectionGui.open();
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        } else {
            player.sendMessage("\u00a7cSection not found: " + sectionId);
        }
    }

    private void openSearchGUI(Player player) {
        SearchGui searchGui = new SearchGui(this.plugin, player);
        this.activeSearchGuis.put(player, searchGui);
        searchGui.open();
        this.playSound(player, Sound.UI_BUTTON_CLICK);
    }

    private void openQuickSell(Player player) {
        QuickSellGui quickSellGui = new QuickSellGui(this.plugin, player);
        this.activeQuickSellGuis.put(player, quickSellGui);
        this.plugin.getGuiManager().getActiveQuickSellGuis().put(player, quickSellGui);
        quickSellGui.open();
        this.playSound(player, Sound.UI_BUTTON_CLICK);
    }

    private void openTransactionHistory(Player player) {
        TransactionHistoryGui historyGui = new TransactionHistoryGui(this.plugin, player);
        this.activeTransactionGuis.put(player, historyGui);
        historyGui.open();
        this.playSound(player, Sound.UI_BUTTON_CLICK);
    }

    private void openSettings(Player player) {
        new ShopSettingsGui(this.plugin, player).open();
        this.playSound(player, Sound.UI_BUTTON_CLICK);
    }

    private void handlePreviousPage(Player player) {
        int currentPage = this.playerCurrentPage.getOrDefault(player, 0);
        Logger.debug("Previous page - Current: " + currentPage);
        if (currentPage > 0) {
            this.playerCurrentPage.put(player, currentPage - 1);
            String sectionId = this.playerCurrentSection.get(player);
            if (sectionId != null) {
                this.openSectionWithPage(player, sectionId, currentPage - 1);
            } else {
                Logger.warn("No section ID found for player " + player.getName() + " during previous page navigation");
            }
        } else {
            player.sendMessage("\u00a7c\ud83d\udcd6 You're already on the first page!");
        }
    }

    private void handleNextPage(Player player) {
        String sectionId = this.playerCurrentSection.get(player);
        if (sectionId == null) {
            Logger.warn("No section ID found for player " + player.getName() + " during next page navigation");
            return;
        }
        ShopSection section = this.plugin.getGuiManager().getSections().get(sectionId);
        if (section == null) {
            Logger.warn("Section not found: " + sectionId + " for player " + player.getName());
            return;
        }
        int currentPage = this.playerCurrentPage.getOrDefault(player, 0);
        int totalPages = (int)Math.ceil((double)section.getItems().size() / 28.0);
        Logger.debug("Next page - Current: " + currentPage + ", Total: " + totalPages);
        if (currentPage < totalPages - 1) {
            this.playerCurrentPage.put(player, currentPage + 1);
            this.openSectionWithPage(player, sectionId, currentPage + 1);
        } else {
            player.sendMessage("\u00a7c\ud83d\udcd6 You're already on the last page!");
        }
    }

    private void openSectionWithPage(Player player, String sectionId, int page) {
        Logger.debug("Opening section " + sectionId + " page " + page);
        ShopSection section = this.plugin.getGuiManager().getSections().get(sectionId);
        if (section != null) {
            SectionGui sectionGui = new SectionGui(this.plugin, player, section);
            sectionGui.setCurrentPage(page);
            this.activeSectionGuis.put(player, sectionGui);
            sectionGui.open();
        }
    }

    private void refreshCurrentGUI(Player player) {
        String sectionId = this.playerCurrentSection.get(player);
        if (sectionId != null) {
            int currentPage = this.playerCurrentPage.getOrDefault(player, 0);
            this.openSectionWithPage(player, sectionId, currentPage);
        }
    }

    private void handleItemTransactionFromSearch(Player player, ShopItem shopItem, ClickType clickType, SearchGui searchGui) {
        Logger.debug("Handling search transaction - Item: " + shopItem.getId() + ", Click: " + String.valueOf(clickType));
        switch (clickType) {
            case LEFT: {
                this.buyItem(player, shopItem, 1);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (searchGui != null && player.getOpenInventory() != null) {
                        searchGui.open();
                    }
                }, 2L);
                break;
            }
            case RIGHT: {
                this.sellItem(player, shopItem, 1);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (searchGui != null && player.getOpenInventory() != null) {
                        searchGui.open();
                    }
                }, 2L);
                break;
            }
            case SHIFT_LEFT: {
                this.buyItem(player, shopItem, 64);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (searchGui != null && player.getOpenInventory() != null) {
                        searchGui.open();
                    }
                }, 2L);
                break;
            }
            case SHIFT_RIGHT: {
                this.sellAllItems(player, shopItem);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (searchGui != null && player.getOpenInventory() != null) {
                        searchGui.open();
                    }
                }, 2L);
                break;
            }
            default: {
                Logger.debug("Unhandled click type from search: " + String.valueOf(clickType));
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.waitingForSearch.getOrDefault(player, false).booleanValue()) {
            event.setCancelled(true);
            this.waitingForSearch.remove(player);
            String message = event.getMessage().trim();
            if (message.equalsIgnoreCase("cancel")) {
                player.sendMessage("\u00a7c\ud83d\udd0d Search cancelled!");
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    SearchGui searchGui = new SearchGui(this.plugin, player);
                    this.activeSearchGuis.put(player, searchGui);
                    searchGui.open();
                });
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.sendMessage("\u00a7b\ud83d\udd0d Searching for: \u00a7e'" + message + "'");
                SearchGui searchGui = new SearchGui(this.plugin, player, message);
                this.activeSearchGuis.put(player, searchGui);
                searchGui.open();
            });
        }
    }

    private boolean hasInventorySpace(Player player, int amount) {
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++emptySlots;
        }
        return (double)emptySlots >= Math.ceil((double)amount / 64.0);
    }

    private int getPlayerItemCount(Player player, Material material) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void removeItemsFromInventory(Player player, Material material, int amount) {
        int remaining = amount;
        for (int i = 0; i < player.getInventory().getSize() && remaining > 0; ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || item.getType() != material) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remaining) {
                player.getInventory().setItem(i, null);
                remaining -= itemAmount;
                continue;
            }
            item.setAmount(itemAmount - remaining);
            remaining = 0;
        }
    }

    private void playSound(Player player, Sound sound) {
        try {
            player.playSound(player.getLocation(), sound, 0.5f, 1.0f);
        }
        catch (Exception e) {
            Logger.debug("Could not play sound: " + String.valueOf(sound));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String title = MessageUtils.stripColor(event.getView().getTitle());
        if (title.contains("SEARCH ITEMS")) {
            if (!this.waitingForSearch.getOrDefault(player, false).booleanValue()) {
                this.activeSearchGuis.remove(player);
            }
        } else if (title.contains("QUICK SELL")) {
            this.activeQuickSellGuis.remove(player);
        } else if (title.contains("TRANSACTION HISTORY")) {
            this.activeTransactionGuis.remove(player);
        } else if (title.contains("SECTION") || title.contains("BLOCKS") || title.contains("ORES") || title.contains("FOOD") || title.contains("REDSTONE") || title.contains("FARMING") || title.contains("DECORATION")) {
            this.activeSectionGuis.remove(player);
        }
        if (this.isShopGUI(title)) {
            this.playSound(player, Sound.UI_BUTTON_CLICK);
        }
    }
}

