/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.managers;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.Transaction;
import dev.turjo.easyshopgui.utils.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class TransactionManager {
    private final EasyShopGUI plugin;
    private final Map<UUID, List<Transaction>> playerTransactions;
    private final int MAX_TRANSACTIONS_PER_PLAYER = 100;

    public TransactionManager(EasyShopGUI plugin) {
        this.plugin = plugin;
        this.playerTransactions = new ConcurrentHashMap<UUID, List<Transaction>>();
    }

    public void recordTransaction(Player player, String type, String itemName, int quantity, double amount) {
        UUID playerId = player.getUniqueId();
        Transaction transaction = new Transaction(type, itemName, quantity, amount, new Date());
        transaction.setPlayerId(playerId.toString());
        List transactions = this.playerTransactions.computeIfAbsent(playerId, k -> new ArrayList());
        transactions.add(0, transaction);
        if (transactions.size() > 100) {
            transactions.remove(transactions.size() - 1);
        }
        Logger.debug("Recorded transaction for " + player.getName() + ": " + type + " " + quantity + "x " + itemName + " for $" + amount);
        this.saveTransactionToDatabase(transaction);
    }

    public List<Transaction> getPlayerTransactions(Player player) {
        return this.playerTransactions.getOrDefault(player.getUniqueId(), new ArrayList());
    }

    public List<Transaction> getRecentTransactions(Player player, int limit) {
        List<Transaction> allTransactions = this.getPlayerTransactions(player);
        return allTransactions.subList(0, Math.min(limit, allTransactions.size()));
    }

    public void clearPlayerTransactions(Player player) {
        this.playerTransactions.remove(player.getUniqueId());
        Logger.debug("Cleared transactions for " + player.getName());
    }

    public double getTotalSpent(Player player) {
        return this.getPlayerTransactions(player).stream().filter(t -> t.getType().equals("BUY")).mapToDouble(Transaction::getAmount).sum();
    }

    public double getTotalEarned(Player player) {
        return this.getPlayerTransactions(player).stream().filter(t -> t.getType().equals("SELL")).mapToDouble(Transaction::getAmount).sum();
    }

    public int getTransactionCount(Player player) {
        return this.getPlayerTransactions(player).size();
    }

    private void saveTransactionToDatabase(Transaction transaction) {
    }

    public void loadPlayerTransactions(Player player) {
    }
}

