/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.models;

import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopItem {
    private String id;
    private String displayName;
    private String description;
    private Material material;
    private double buyPrice;
    private double sellPrice;
    private int stock;
    private String demand;
    private List<String> lore;
    private Map<Enchantment, Integer> enchantments;
    private String permission;
    private boolean glowing;
    private String nbtData;

    public ShopItem(String id, String displayName, Material material, double buyPrice, double sellPrice) {
        this.id = id;
        this.displayName = displayName;
        this.material = material;
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        this.stock = -1;
        this.demand = "medium";
        this.description = "A quality item from our shop";
    }

    public ItemStack createItemStack(int amount) {
        ItemStack item = new ItemStack(this.material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.displayName);
            if (this.lore != null) {
                meta.setLore(this.lore);
            }
            if (this.enchantments != null) {
                for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
                    meta.addEnchant(entry.getKey(), entry.getValue().intValue(), true);
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public void setBuyPrice(double buyPrice) {
        this.buyPrice = buyPrice;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = sellPrice;
    }

    public int getStock() {
        return this.stock;
    }

    public void setStock(int stock) {
        this.stock = stock;
    }

    public String getDemand() {
        return this.demand;
    }

    public void setDemand(String demand) {
        this.demand = demand;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
    }

    public String getNbtData() {
        return this.nbtData;
    }

    public void setNbtData(String nbtData) {
        this.nbtData = nbtData;
    }
}

