/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class Logger {
    private static final String PREFIX = "[EasyShopGUI] ";
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static boolean debugMode = false;

    public static void setDebugMode(boolean debug) {
        debugMode = debug;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void info(String message) {
        Bukkit.getLogger().info(PREFIX + message);
    }

    public static void warn(String message) {
        Bukkit.getLogger().warning(PREFIX + message);
    }

    public static void error(String message) {
        Bukkit.getLogger().severe(PREFIX + message);
    }

    public static void debug(String message) {
        if (debugMode) {
            String timestamp = LocalDateTime.now().format(TIME_FORMAT);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "[EasyShopGUI] [DEBUG " + timestamp + "] " + String.valueOf(ChatColor.GRAY) + message);
        }
    }

    public static void debugColor(String message) {
        if (debugMode) {
            String timestamp = LocalDateTime.now().format(TIME_FORMAT);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "[EasyShopGUI] [DEBUG " + timestamp + "] " + String.valueOf(ChatColor.GRAY) + message);
        }
    }

    public static void exception(String message, Exception e) {
        Logger.error(message + ": " + e.getMessage());
        if (debugMode) {
            e.printStackTrace();
        }
    }
}

