/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class MessageUtils {
    public static String colorize(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static List<String> colorize(List<String> messages) {
        if (messages == null) {
            return null;
        }
        return messages.stream().map(MessageUtils::colorize).collect(Collectors.toList());
    }

    public static String stripColor(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.stripColor((String)MessageUtils.colorize(message));
    }

    public static String formatNumber(double number) {
        return String.format("%,.2f", number);
    }

    public static String formatCurrency(double amount) {
        return "$" + MessageUtils.formatNumber(amount);
    }

    public static String getProgressBar(int current, int max, int length, char symbol, String completeColor, String incompleteColor) {
        double percentage = (double)current / (double)max;
        int completed = (int)(percentage * (double)length);
        StringBuilder bar = new StringBuilder();
        bar.append(completeColor);
        for (int i = 0; i < length; ++i) {
            if (i < completed) {
                bar.append(symbol);
                continue;
            }
            bar.append(incompleteColor).append(symbol);
        }
        return bar.toString();
    }

    public static String centerText(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        int spaces = (length - text.length()) / 2;
        StringBuilder centered = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            centered.append(" ");
        }
        centered.append(text);
        return centered.toString();
    }
}

