/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui;

import dev.turjo.easyshopgui.commands.ShopCommand;
import dev.turjo.easyshopgui.commands.WithdrawCommand;
import dev.turjo.easyshopgui.config.ConfigManager;
import dev.turjo.easyshopgui.currency.PaperCurrency;
import dev.turjo.easyshopgui.database.DatabaseManager;
import dev.turjo.easyshopgui.economy.EconomyManager;
import dev.turjo.easyshopgui.gui.GuiManager;
import dev.turjo.easyshopgui.hooks.HookManager;
import dev.turjo.easyshopgui.listeners.CurrencyListener;
import dev.turjo.easyshopgui.listeners.GuiListener;
import dev.turjo.easyshopgui.listeners.PlayerListener;
import dev.turjo.easyshopgui.managers.ShopManager;
import dev.turjo.easyshopgui.managers.TransactionManager;
import dev.turjo.easyshopgui.marketplace.AIMarketplace;
import dev.turjo.easyshopgui.placeholders.EasyShopPlaceholderExpansion;
import dev.turjo.easyshopgui.schedulers.CronScheduler;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EasyShopGUI
extends JavaPlugin {
    private static EasyShopGUI instance;
    private long startTime;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private EconomyManager economyManager;
    private ShopManager shopManager;
    private GuiManager guiManager;
    private TransactionManager transactionManager;
    private HookManager hookManager;
    private CronScheduler cronScheduler;
    private UpdateChecker updateChecker;
    private PaperCurrency paperCurrency;
    private AIMarketplace aiMarketplace;

    public void onEnable() {
        instance = this;
        this.startTime = System.currentTimeMillis();
        Logger.info("Starting EasyShopGUI v" + this.getDescription().getVersion());
        Logger.info("Developed by Turjo - Premium Minecraft Shop Plugin");
        if (!this.initializePlugin()) {
            Logger.error("Failed to initialize plugin! Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Logger.info("EasyShopGUI has been successfully enabled!");
        Logger.info("Thank you for using EasyShopGUI - The Ultimate Shop Solution!");
    }

    public void onDisable() {
        Logger.info("Disabling EasyShopGUI...");
        if (this.cronScheduler != null) {
            this.cronScheduler.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.closeConnections();
        }
        Logger.info("EasyShopGUI has been disabled successfully!");
    }

    private boolean initializePlugin() {
        try {
            this.configManager = new ConfigManager(this);
            this.configManager.loadConfigs();
            this.databaseManager = new DatabaseManager(this);
            if (!this.databaseManager.initialize()) {
                Logger.error("Failed to initialize database!");
                return false;
            }
            this.economyManager = new EconomyManager(this);
            if (!this.economyManager.setupEconomy()) {
                Logger.error("Failed to setup economy! Vault is required.");
                return false;
            }
            this.shopManager = new ShopManager(this);
            this.guiManager = new GuiManager(this);
            this.transactionManager = new TransactionManager(this);
            this.hookManager = new HookManager(this);
            this.cronScheduler = new CronScheduler(this);
            this.updateChecker = new UpdateChecker(this);
            this.paperCurrency = new PaperCurrency(this);
            this.aiMarketplace = new AIMarketplace(this);
            this.registerCommands();
            this.registerListeners();
            this.hookManager.setupHooks();
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new EasyShopPlaceholderExpansion(this).register();
                Logger.info("PlaceholderAPI expansion registered!");
            }
            this.cronScheduler.startSchedulers();
            this.updateChecker.checkForUpdates();
            Logger.setDebugMode(this.configManager.getMainConfig().getBoolean("plugin.debug", true));
            return true;
        }
        catch (Exception e) {
            Logger.error("Error during plugin initialization: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void registerCommands() {
        try {
            ShopCommand shopCommand = new ShopCommand(this);
            if (this.getCommand("shop") != null) {
                this.getCommand("shop").setExecutor((CommandExecutor)shopCommand);
                this.getCommand("shop").setTabCompleter((TabCompleter)shopCommand);
            } else {
                Logger.warn("Command 'shop' not found in plugin.yml");
            }
            if (this.getCommand("sell") != null) {
                this.getCommand("sell").setExecutor((CommandExecutor)shopCommand);
                this.getCommand("sell").setTabCompleter((TabCompleter)shopCommand);
            } else {
                Logger.warn("Command 'sell' not found in plugin.yml");
            }
            if (this.getCommand("eshop") != null) {
                this.getCommand("eshop").setExecutor((CommandExecutor)shopCommand);
                this.getCommand("eshop").setTabCompleter((TabCompleter)shopCommand);
            } else {
                Logger.warn("Command 'eshop' not found in plugin.yml");
            }
            if (this.getCommand("withdraw") != null) {
                this.getCommand("withdraw").setExecutor((CommandExecutor)new WithdrawCommand(this));
                this.getCommand("withdraw").setTabCompleter((TabCompleter)new WithdrawCommand(this));
            } else {
                Logger.warn("Command 'withdraw' not found in plugin.yml");
            }
            Logger.info("Commands registered successfully!");
        }
        catch (Exception e) {
            Logger.error("Error registering commands: " + e.getMessage());
            throw e;
        }
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CurrencyListener(this), (Plugin)this);
    }

    public static EasyShopGUI getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public CronScheduler getCronScheduler() {
        return this.cronScheduler;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PaperCurrency getPaperCurrency() {
        return this.paperCurrency;
    }

    public AIMarketplace getAiMarketplace() {
        return this.aiMarketplace;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

