/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.commands;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.gui.QuickSellGui;
import dev.turjo.easyshopgui.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ShopCommand
implements CommandExecutor,
TabCompleter {
    private final EasyShopGUI plugin;

    public ShopCommand(EasyShopGUI plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("shop")) {
            return this.handleShopCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("sell")) {
            return this.handleSellCommand(sender, args);
        }
        if (command.getName().equalsIgnoreCase("eshop")) {
            return this.handleAdminCommand(sender, args);
        }
        return false;
    }

    private boolean handleShopCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easyshopgui.use")) {
            player.sendMessage("\u00a7cYou don't have permission to use shops!");
            return true;
        }
        String shopName = args.length > 0 ? args[0] : "main";
        this.plugin.getGuiManager().openShop(player, shopName);
        return true;
    }

    private boolean handleSellCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easyshopgui.sell")) {
            player.sendMessage("\u00a7cYou don't have permission to use the sell GUI!");
            return true;
        }
        QuickSellGui quickSellGui = new QuickSellGui(this.plugin, player);
        if (this.plugin.getServer().getPluginManager().isPluginEnabled((Plugin)this.plugin)) {
            this.plugin.getGuiManager().getActiveQuickSellGuis().put(player, quickSellGui);
        }
        quickSellGui.open();
        player.sendMessage("\u00a7a\ud83d\udcb8 Quick Sell GUI opened! Drop items to sell them.");
        return true;
    }

    private boolean handleAdminCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (!sender.hasPermission("easyshopgui.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use admin commands!");
            return true;
        }
        if (args.length == 0) {
            this.sendAdminHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": 
            case "rl": {
                this.plugin.getConfigManager().reloadAllConfigs();
                this.plugin.getGuiManager().reloadSections();
                sender.sendMessage("\u00a7aConfiguration reloaded successfully!");
                break;
            }
            case "update": {
                this.plugin.getUpdateChecker().checkForUpdates();
                sender.sendMessage("\u00a7aChecking for updates...");
                break;
            }
            case "info": 
            case "version": 
            case "ver": {
                this.sendPluginInfo(sender);
                break;
            }
            case "debug": {
                boolean currentDebug = this.plugin.getConfigManager().getMainConfig().getBoolean("plugin.debug", false);
                this.plugin.getConfigManager().getMainConfig().set("plugin.debug", (Object)(!currentDebug ? 1 : 0));
                this.plugin.getConfigManager().saveConfig("config.yml");
                Logger.setDebugMode(!currentDebug);
                sender.sendMessage("\u00a7aDebug mode " + (!currentDebug ? "\u00a7aenabled" : "\u00a7cdisabled") + "!");
                break;
            }
            case "stats": 
            case "statistics": {
                this.sendStatistics(sender);
                break;
            }
            case "help": {
                this.sendAdminHelp(sender);
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand: " + subCommand);
                this.sendAdminHelp(sender);
            }
        }
        return true;
    }

    private void sendAdminHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== EasyShopGUI Admin Commands ===");
        sender.sendMessage("\u00a7e/eshop reload \u00a77(\u00a7e/eshop rl\u00a77) - Reload configuration");
        sender.sendMessage("\u00a7e/eshop update \u00a77- Check for updates");
        sender.sendMessage("\u00a7e/eshop info \u00a77(\u00a7e/eshop ver\u00a77) - Show plugin information");
        sender.sendMessage("\u00a7e/eshop debug \u00a77- Toggle debug mode");
        sender.sendMessage("\u00a7e/eshop stats \u00a77- Show plugin statistics");
        sender.sendMessage("\u00a7e/eshop help \u00a77- Show this help message");
        sender.sendMessage("\u00a76\u00a7l=== Player Commands ===");
        sender.sendMessage("\u00a7e/shop \u00a77- Open main shop");
        sender.sendMessage("\u00a7e/sell \u00a77- Open quick sell GUI");
    }

    private void sendPluginInfo(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== EasyShopGUI Information ===");
        sender.sendMessage("\u00a7eVersion: \u00a7f" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a7eAuthor: \u00a7f" + (String)this.plugin.getDescription().getAuthors().get(0));
        sender.sendMessage("\u00a7eWebsite: \u00a7f" + this.plugin.getDescription().getWebsite());
        sender.sendMessage("\u00a7eDescription: \u00a7f" + this.plugin.getDescription().getDescription());
    }

    private void sendStatistics(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== EasyShopGUI Statistics ===");
        sender.sendMessage("\u00a7eTotal Sections: \u00a7f" + this.plugin.getGuiManager().getSections().size());
        int totalItems = this.plugin.getGuiManager().getSections().values().stream().mapToInt(section -> section.getItems().size()).sum();
        sender.sendMessage("\u00a7eTotal Items: \u00a7f" + totalItems);
        sender.sendMessage("\u00a7eDebug Mode: \u00a7f" + (Logger.isDebugMode() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("\u00a7eUptime: \u00a7f" + this.getUptime());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("shop")) {
            if (args.length == 1) {
                completions.addAll(Arrays.asList("main", "blocks", "items", "tools", "food"));
            }
        } else if (!command.getName().equalsIgnoreCase("sell") && command.getName().equalsIgnoreCase("eshop") && args.length == 1) {
            completions.addAll(Arrays.asList("reload", "rl", "update", "info", "version", "ver", "debug", "stats", "statistics", "help"));
        }
        return completions;
    }

    private String getUptime() {
        long uptime = System.currentTimeMillis() - this.plugin.getStartTime();
        long seconds = uptime / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return String.format("%dh %dm %ds", hours % 24L, minutes % 60L, seconds % 60L);
    }
}

