/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.commands;

import dev.turjo.easyshopgui.EasyShopGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class WithdrawCommand
implements CommandExecutor,
TabCompleter {
    private final EasyShopGUI plugin;

    public WithdrawCommand(EasyShopGUI plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easyshopgui.withdraw")) {
            player.sendMessage("\u00a7cYou don't have permission to withdraw money as cheques!");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Usage: /withdraw <amount>");
            player.sendMessage("\u00a7e\ud83d\udca1 Example: /withdraw 100");
            return true;
        }
        try {
            amount = Double.parseDouble(args[0]);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Invalid amount! Please enter a valid number.");
            return true;
        }
        boolean success = this.plugin.getPaperCurrency().withdrawCheque(player, amount);
        if (!success) {
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("10", "50", "100", "500", "1000", "5000", "10000"));
        }
        return completions;
    }
}

