/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.config;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final EasyShopGUI plugin;
    private final Map<String, FileConfiguration> configs;
    private final Map<String, File> configFiles;

    public ConfigManager(EasyShopGUI plugin) {
        this.plugin = plugin;
        this.configs = new HashMap<String, FileConfiguration>();
        this.configFiles = new HashMap<String, File>();
    }

    public void loadConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.loadConfig("config.yml");
        this.loadConfig("messages.yml");
        this.loadConfig("sections.yml");
        this.loadConfig("items.yml");
        this.loadConfig("gui.yml");
        this.loadLanguageFiles();
        Logger.info("Configuration files loaded successfully!");
    }

    private void loadConfig(String fileName) {
        File configFile = new File(this.plugin.getDataFolder(), fileName);
        if (!configFile.exists()) {
            this.createDefaultConfig(fileName, configFile);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.configs.put(fileName, (FileConfiguration)config);
        this.configFiles.put(fileName, configFile);
        Logger.debug("Loaded configuration: " + fileName);
    }

    private void createDefaultConfig(String fileName, File configFile) {
        try {
            InputStream inputStream = this.plugin.getResource(fileName);
            if (inputStream != null) {
                Files.copy(inputStream, configFile.toPath(), new CopyOption[0]);
                Logger.info("Created default configuration: " + fileName);
            } else {
                configFile.createNewFile();
                Logger.warn("Resource not found, created empty file: " + fileName);
            }
        }
        catch (IOException e) {
            Logger.error("Failed to create configuration file: " + fileName);
            e.printStackTrace();
        }
    }

    private void loadLanguageFiles() {
        String[] languages;
        File langDir = new File(this.plugin.getDataFolder(), "languages");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        for (String lang : languages = new String[]{"en_US", "es_ES", "fr_FR", "de_DE", "it_IT", "pt_BR", "ru_RU", "zh_CN", "ja_JP", "ko_KR"}) {
            String fileName = "messages_" + lang + ".yml";
            File langFile = new File(langDir, fileName);
            if (langFile.exists()) continue;
            try {
                InputStream inputStream = this.plugin.getResource("languages/" + fileName);
                if (inputStream == null) continue;
                Files.copy(inputStream, langFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.debug("Language file not found: " + fileName);
            }
        }
    }

    public FileConfiguration getConfig(String configName) {
        return this.configs.get(configName);
    }

    public FileConfiguration getMainConfig() {
        return this.getConfig("config.yml");
    }

    public FileConfiguration getMessages() {
        return this.getConfig("messages.yml");
    }

    public FileConfiguration getSections() {
        return this.getConfig("sections.yml");
    }

    public FileConfiguration getItems() {
        return this.getConfig("items.yml");
    }

    public FileConfiguration getGui() {
        return this.getConfig("gui.yml");
    }

    public void saveConfig(String configName) {
        try {
            FileConfiguration config = this.configs.get(configName);
            File configFile = this.configFiles.get(configName);
            if (config != null && configFile != null) {
                config.save(configFile);
                Logger.debug("Saved configuration: " + configName);
            }
        }
        catch (IOException e) {
            Logger.error("Failed to save configuration: " + configName);
            e.printStackTrace();
        }
    }

    public void saveAllConfigs() {
        for (String configName : this.configs.keySet()) {
            this.saveConfig(configName);
        }
    }

    public void reloadConfig(String configName) {
        File configFile = this.configFiles.get(configName);
        if (configFile != null) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            this.configs.put(configName, (FileConfiguration)config);
            Logger.debug("Reloaded configuration: " + configName);
        }
    }

    public void reloadAllConfigs() {
        for (String configName : this.configs.keySet()) {
            this.reloadConfig(configName);
        }
        Logger.info("All configurations reloaded!");
    }
}

