/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.data;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.data.ShopData;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.Logger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopDataLoader {
    private final EasyShopGUI plugin;

    public ShopDataLoader(EasyShopGUI plugin) {
        this.plugin = plugin;
    }

    public Map<String, ShopSection> loadSections() {
        HashMap<String, ShopSection> sections = new HashMap<String, ShopSection>();
        File sectionsDir = new File(this.plugin.getDataFolder(), "sections");
        if (!sectionsDir.exists()) {
            sectionsDir.mkdirs();
            Logger.info("Created sections directory");
        }
        this.createDefaultSectionFiles(sectionsDir);
        File[] sectionFiles = sectionsDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (sectionFiles == null || sectionFiles.length == 0) {
            Logger.error("No section files found! Creating default sections...");
            return ShopData.createDefaultSections();
        }
        for (File sectionFile : sectionFiles) {
            try {
                YamlConfiguration sectionConfig = YamlConfiguration.loadConfiguration((File)sectionFile);
                ShopSection section = this.loadSectionFromFile((FileConfiguration)sectionConfig, sectionFile.getName());
                if (section == null) continue;
                sections.put(section.getId(), section);
                Logger.info("Loaded section: " + section.getId() + " with " + section.getItems().size() + " items");
            }
            catch (Exception e) {
                Logger.error("Failed to load section file: " + sectionFile.getName() + " - " + e.getMessage());
                e.printStackTrace();
            }
        }
        Logger.info("Loaded " + sections.size() + " shop sections from configuration");
        return sections;
    }

    private void createDefaultSectionFiles(File sectionsDir) {
        String[] sectionFiles;
        for (String fileName : sectionFiles = new String[]{"blocks.yml", "ores.yml", "food.yml", "redstone.yml", "farming.yml", "decoration.yml", "potions.yml"}) {
            File sectionFile = new File(sectionsDir, fileName);
            if (sectionFile.exists()) continue;
            try {
                InputStream inputStream = this.plugin.getResource("sections/" + fileName);
                if (inputStream != null) {
                    Files.copy(inputStream, sectionFile.toPath(), new CopyOption[0]);
                    Logger.info("Created default section file: " + fileName);
                    continue;
                }
                Logger.warn("Resource not found for section: " + fileName);
            }
            catch (Exception e) {
                Logger.error("Failed to create section file: " + fileName + " - " + e.getMessage());
            }
        }
    }

    private ShopSection loadSectionFromFile(FileConfiguration config, String fileName) {
        Material icon;
        ConfigurationSection sectionConfig = config.getConfigurationSection("section");
        if (sectionConfig == null) {
            Logger.error("Invalid section file format - missing 'section' configuration in " + fileName);
            return null;
        }
        if (!sectionConfig.getBoolean("enabled", true)) {
            Logger.debug("Section is disabled, skipping: " + fileName);
            return null;
        }
        String id = sectionConfig.getString("id", "unknown");
        String name = sectionConfig.getString("name", id);
        String displayName = sectionConfig.getString("display-name", name);
        String iconName = sectionConfig.getString("icon", "STONE");
        try {
            icon = Material.valueOf((String)iconName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Logger.warn("Invalid material for section " + id + ": " + iconName + ", using STONE");
            icon = Material.STONE;
        }
        ShopSection section = new ShopSection(id, name, displayName, icon);
        section.setDescription(sectionConfig.getString("description", ""));
        section.setPermission(sectionConfig.getString("permission", ""));
        ConfigurationSection itemsConfig = config.getConfigurationSection("items");
        if (itemsConfig != null) {
            int itemCount = this.loadItemsForSection(section, itemsConfig);
            Logger.debug("Loaded " + itemCount + " items for section " + id);
        } else {
            Logger.warn("No items section found in " + fileName);
        }
        return section;
    }

    private int loadItemsForSection(ShopSection section, ConfigurationSection itemsConfig) {
        int itemCount = 0;
        for (String itemId : itemsConfig.getKeys(false)) {
            ConfigurationSection itemConfig = itemsConfig.getConfigurationSection(itemId);
            if (itemConfig == null) {
                Logger.warn("Invalid item configuration for " + itemId + " in section " + section.getId() + ", skipping");
                continue;
            }
            try {
                Material material;
                String materialName = itemConfig.getString("material", "STONE");
                try {
                    material = Material.valueOf((String)materialName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Logger.warn("Invalid material for item " + itemId + ": " + materialName + ", skipping");
                    continue;
                }
                double buyPrice = itemConfig.getDouble("buy-price", 1.0);
                double sellPrice = itemConfig.getDouble("sell-price", 0.5);
                String displayName = itemConfig.getString("name", itemId);
                ShopItem item = new ShopItem(itemId, displayName, material, buyPrice, sellPrice);
                item.setDescription(itemConfig.getString("description", ""));
                item.setStock(itemConfig.getInt("stock", -1));
                item.setDemand(itemConfig.getString("demand", "medium"));
                item.setPermission(itemConfig.getString("permission", ""));
                section.addItem(item);
                ++itemCount;
            }
            catch (Exception e) {
                Logger.error("Failed to load item " + itemId + " in section " + section.getId() + ": " + e.getMessage());
            }
        }
        return itemCount;
    }
}

