/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class QuickSellGui {
    private final EasyShopGUI plugin;
    private final Player player;
    public Map<Material, SellableItem> sellableItems = new HashMap<Material, SellableItem>();
    private double totalValue = 0.0;
    public static final int[] SELL_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public QuickSellGui(EasyShopGUI plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.analyzeSellableItems();
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&c&l\ud83d\udcb8 &e&lQUICK SELL"));
        this.fillBackground(gui);
        this.addSellActions(gui);
        this.addNavigation(gui);
        this.addInstructions(gui);
        this.updateValueDisplay(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        ItemStack background = new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
        for (int slot : SELL_SLOTS) {
            gui.setItem(slot, null);
        }
    }

    public boolean isSellSlot(int slot) {
        for (int sellSlot : SELL_SLOTS) {
            if (sellSlot != slot) continue;
            return true;
        }
        return false;
    }

    public double calculateTotalValue(Inventory gui) {
        double total = 0.0;
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        HashMap<Material, ShopItem> shopItemMap = new HashMap<Material, ShopItem>();
        for (ShopSection section : sections.values()) {
            for (ShopItem item : section.getItems()) {
                shopItemMap.put(item.getMaterial(), item);
            }
        }
        for (Object slot : (Object)SELL_SLOTS) {
            ShopItem shopItem;
            ItemStack item = gui.getItem((int)slot);
            if (item == null || item.getType() == Material.AIR || (shopItem = (ShopItem)shopItemMap.get(item.getType())) == null || !(shopItem.getSellPrice() > 0.0)) continue;
            total += shopItem.getSellPrice() * (double)item.getAmount();
        }
        return total;
    }

    public void sellAllItems(Inventory gui) {
        double totalEarned = 0.0;
        int itemsSold = 0;
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        HashMap<Material, ShopItem> shopItemMap = new HashMap<Material, ShopItem>();
        for (ShopSection section : sections.values()) {
            for (ShopItem item : section.getItems()) {
                shopItemMap.put(item.getMaterial(), item);
            }
        }
        for (Object slot : (Object)SELL_SLOTS) {
            ShopItem shopItem;
            ItemStack item = gui.getItem((int)slot);
            if (item == null || item.getType() == Material.AIR || (shopItem = (ShopItem)shopItemMap.get(item.getType())) == null || !(shopItem.getSellPrice() > 0.0)) continue;
            double earned = shopItem.getSellPrice() * (double)item.getAmount();
            this.plugin.getEconomyManager().getEconomy().depositPlayer((OfflinePlayer)this.player, earned);
            this.plugin.getTransactionManager().recordTransaction(this.player, "SELL", shopItem.getDisplayName(), item.getAmount(), earned);
            totalEarned += earned;
            itemsSold += item.getAmount();
            gui.setItem((int)slot, null);
        }
        if (totalEarned > 0.0) {
            this.player.sendMessage("\u00a7a\ud83d\udc8e Sold " + itemsSold + " items for \u00a76$" + String.format("%.2f", totalEarned) + "!");
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        } else {
            this.player.sendMessage("\u00a7c\u274c No sellable items found!");
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
        this.updateValueDisplay(gui);
    }

    public void clearAllItems(Inventory gui) {
        int itemsReturned = 0;
        for (int slot : SELL_SLOTS) {
            ItemStack item = gui.getItem(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            HashMap leftover = this.player.getInventory().addItem(new ItemStack[]{item});
            if (!leftover.isEmpty()) {
                for (ItemStack leftoverItem : leftover.values()) {
                    this.player.getWorld().dropItemNaturally(this.player.getLocation(), leftoverItem);
                }
            }
            itemsReturned += item.getAmount();
            gui.setItem(slot, null);
        }
        if (itemsReturned > 0) {
            this.player.sendMessage("\u00a7e\ud83d\udce6 Returned " + itemsReturned + " items to your inventory!");
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        } else {
            this.player.sendMessage("\u00a7c\u274c No items to return!");
        }
        this.updateValueDisplay(gui);
    }

    public void updateValueDisplay(Inventory gui) {
        double currentValue = this.calculateTotalValue(gui);
        gui.setItem(4, new ItemBuilder(Material.EMERALD).setName("&a&l\ud83d\udcb0 &e&lTOTAL VALUE").setLore(Arrays.asList("&7\u25b8 &fItems in Sell Slots: &e" + this.countItemsInSlots(gui), "&7\u25b8 &fTotal Value: &a$" + String.format("%.2f", currentValue), "&7\u25b8 &fCurrent Balance: &e$" + String.format("%.2f", this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player)), "&7\u25b8 &fAfter Selling: &a$" + String.format("%.2f", this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player) + currentValue), "", "&a&l\ud83d\udca1 &aDrag items into empty slots to sell!")).addGlow(currentValue > 0.0).build());
    }

    private int countItemsInSlots(Inventory gui) {
        int count = 0;
        for (int slot : SELL_SLOTS) {
            ItemStack item = gui.getItem(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            count += item.getAmount();
        }
        return count;
    }

    private void analyzeSellableItems() {
        this.sellableItems.clear();
        this.totalValue = 0.0;
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        HashMap<Material, ShopItem> shopItemMap = new HashMap<Material, ShopItem>();
        for (ShopSection section : sections.values()) {
            for (ShopItem shopItem : section.getItems()) {
                shopItemMap.put(shopItem.getMaterial(), shopItem);
            }
        }
        for (ItemStack itemStack : this.player.getInventory().getContents()) {
            ShopItem shopItem;
            if (itemStack == null || itemStack.getType() == Material.AIR || (shopItem = (ShopItem)shopItemMap.get(itemStack.getType())) == null || !(shopItem.getSellPrice() > 0.0)) continue;
            SellableItem sellable = this.sellableItems.getOrDefault(itemStack.getType(), new SellableItem(shopItem, 0));
            sellable.count += itemStack.getAmount();
            this.sellableItems.put(itemStack.getType(), sellable);
            this.totalValue += shopItem.getSellPrice() * (double)itemStack.getAmount();
        }
        Logger.debug("Found " + this.sellableItems.size() + " types of sellable items worth $" + String.format("%.2f", this.totalValue));
    }

    private void addSellActions(Inventory gui) {
        gui.setItem(49, new ItemBuilder(Material.DIAMOND).setName("&a&l\ud83d\udc8e &e&lSELL ALL ITEMS").setLore(Arrays.asList("&7\u25b8 &fSell all items in sell slots", "&7\u25b8 &fInstant transaction", "&7\u25b8 &fGet money immediately", "", "&a&l\u27a4 &aClick to sell everything!")).addGlow().build());
        gui.setItem(47, new ItemBuilder(Material.HOPPER).setName("&c&l\ud83d\udce6 &e&lCLEAR ALL ITEMS").setLore(Arrays.asList("&7\u25b8 &fReturn all items to inventory", "&7\u25b8 &fNo selling, just return", "&7\u25b8 &fSafe item retrieval", "", "&c&l\u27a4 &cClick to clear!")).build());
        gui.setItem(51, new ItemBuilder(Material.CHEST).setName("&b&l\ud83d\udd04 &e&lAUTO-FILL FROM INVENTORY").setLore(Arrays.asList("&7\u25b8 &fAutomatically fill with sellable items", "&7\u25b8 &fFrom your inventory", "&7\u25b8 &fOnly sellable items", "", "&b&l\u27a4 &bClick to auto-fill!")).build());
        this.updateValueDisplay(gui);
    }

    public void autoFillFromInventory(Inventory gui) {
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        HashMap<Material, ShopItem> shopItemMap = new HashMap<Material, ShopItem>();
        for (ShopSection section : sections.values()) {
            for (ShopItem item : section.getItems()) {
                shopItemMap.put(item.getMaterial(), item);
            }
        }
        int slotIndex = 0;
        int itemsMoved = 0;
        for (int i = 0; i < this.player.getInventory().getSize() && slotIndex < SELL_SLOTS.length; ++i) {
            ShopItem shopItem;
            ShopItem item;
            item = this.player.getInventory().getItem(i);
            if (item == null || item.getType() == Material.AIR || (shopItem = (ShopItem)shopItemMap.get(item.getType())) == null || !(shopItem.getSellPrice() > 0.0)) continue;
            gui.setItem(SELL_SLOTS[slotIndex], item.clone());
            this.player.getInventory().setItem(i, null);
            itemsMoved += item.getAmount();
            ++slotIndex;
        }
        if (itemsMoved > 0) {
            this.player.sendMessage("\u00a7b\ud83d\udd04 Auto-filled " + itemsMoved + " sellable items!");
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        } else {
            this.player.sendMessage("\u00a7c\u274c No sellable items found in inventory!");
        }
        this.updateValueDisplay(gui);
    }

    private void addInstructions(Inventory gui) {
        gui.setItem(0, new ItemBuilder(Material.BOOK).setName("&b&l\ud83d\udcd6 &e&lHOW TO USE").setLore(Arrays.asList("&7\u25b8 &fDrag items into empty slots", "&7\u25b8 &fOnly sellable items work", "&7\u25b8 &fClick 'Sell All' when ready", "&7\u25b8 &fClick 'Clear All' to get items back", "", "&b&l\ud83d\udca1 &bTip: Use Auto-Fill for convenience!")).build());
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(45, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK TO SHOP").setLore(Arrays.asList("&7\u25b8 &fReturn to main shop", "", "&a&l\u27a4 &aClick to go back!")).build());
    }

    public static class SellableItem {
        public final ShopItem shopItem;
        public int count;

        public SellableItem(ShopItem shopItem, int count) {
            this.shopItem = shopItem;
            this.count = count;
        }

        public double getTotalValue() {
            return this.shopItem.getSellPrice() * (double)this.count;
        }
    }
}

