/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SearchGui {
    private final EasyShopGUI plugin;
    private final Player player;
    private String currentQuery = "";
    private List<ShopItem> searchResults = new ArrayList<ShopItem>();
    private int currentPage = 0;
    private final Map<Player, String> playerSearchQueries = new HashMap<Player, String>();

    public SearchGui(EasyShopGUI plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public SearchGui(EasyShopGUI plugin, Player player, String query) {
        this.plugin = plugin;
        this.player = player;
        this.currentQuery = query;
        this.performSearch();
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&b&l\ud83d\udd0d &e&lSEARCH ITEMS"));
        this.fillBackground(gui);
        if (this.currentQuery.isEmpty()) {
            this.addSearchInterface(gui);
        } else {
            this.addSearchResults(gui);
        }
        this.addNavigation(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        ItemStack background = new ItemBuilder(Material.BLUE_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
    }

    private void addSearchInterface(Inventory gui) {
        gui.setItem(22, new ItemBuilder(Material.COMPASS).setName("&b&l\ud83d\udd0d &e&lSMART SEARCH").setLore(Arrays.asList("&7\u25b8 &fType in chat to search items", "&7\u25b8 &fSmart fuzzy matching", "&7\u25b8 &fSearch by name or material", "&7\u25b8 &fPartial words work too!", "", "&b&l\ud83d\udca1 &bExamples:", "&7  \u2022 &f'dia' \u2192 finds diamonds", "&7  \u2022 &f'iron' \u2192 finds iron items", "&7  \u2022 &f'food' \u2192 finds all food", "&7  \u2022 &f'red' \u2192 finds redstone items", "", "&a&l\u27a4 &aType your search in chat!")).addGlow().build());
        gui.setItem(19, new ItemBuilder(Material.DIAMOND).setName("&b&l\ud83d\udc8e &e&lPOPULAR: DIAMONDS").setLore(Arrays.asList("&7\u25b8 &fQuick search for diamonds", "", "&a&l\u27a4 &aClick to search!")).build());
        gui.setItem(21, new ItemBuilder(Material.IRON_INGOT).setName("&7&l\u2692 &e&lPOPULAR: IRON").setLore(Arrays.asList("&7\u25b8 &fQuick search for iron items", "", "&a&l\u27a4 &aClick to search!")).build());
        gui.setItem(23, new ItemBuilder(Material.BREAD).setName("&6&l\ud83c\udf5e &e&lPOPULAR: FOOD").setLore(Arrays.asList("&7\u25b8 &fQuick search for food items", "", "&a&l\u27a4 &aClick to search!")).build());
        gui.setItem(25, new ItemBuilder(Material.REDSTONE).setName("&c&l\u26a1 &e&lPOPULAR: REDSTONE").setLore(Arrays.asList("&7\u25b8 &fQuick search for redstone", "", "&a&l\u27a4 &aClick to search!")).build());
    }

    private void addSearchResults(Inventory gui) {
        gui.setItem(4, new ItemBuilder(Material.BOOK).setName("&b&l\ud83d\udcca &e&lSEARCH RESULTS").setLore(Arrays.asList("&7\u25b8 &fQuery: &e'" + this.currentQuery + "'", "&7\u25b8 &fResults Found: &a" + this.searchResults.size(), "&7\u25b8 &fPage: &e" + (this.currentPage + 1) + "/" + this.getTotalPages(), "", "&b&l\ud83d\udca1 &bTip: &fClick items to buy/sell!")).build());
        int startIndex = this.currentPage * 28;
        int[] itemSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = 0; i < itemSlots.length && startIndex + i < this.searchResults.size(); ++i) {
            ShopItem item = this.searchResults.get(startIndex + i);
            gui.setItem(itemSlots[i], this.createSearchResultItem(item));
        }
        if (this.searchResults.isEmpty()) {
            gui.setItem(22, new ItemBuilder(Material.BARRIER).setName("&c&l\u274c &e&lNO RESULTS").setLore(Arrays.asList("&7\u25b8 &fNo items found for: &c'" + this.currentQuery + "'", "&7\u25b8 &fTry different keywords", "&7\u25b8 &fCheck spelling", "", "&b&l\ud83d\udca1 &bSuggestions:", "&7  \u2022 &fTry shorter words", "&7  \u2022 &fUse material names", "&7  \u2022 &fSearch by category")).build());
        }
    }

    private ItemStack createSearchResultItem(ShopItem item) {
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        boolean canAfford = balance >= item.getBuyPrice();
        return new ItemBuilder(item.getMaterial()).setName("&e&l\u2b50 " + item.getDisplayName()).setLore(Arrays.asList("&7\u25b8 &fDescription: &7" + item.getDescription(), "", "&7\u25b8 &fPricing:", "&a  Buy: &f$" + String.format("%.2f", item.getBuyPrice()) + (canAfford ? " &a\u2713" : " &c\u2717"), "&c  Sell: &f$" + String.format("%.2f", item.getSellPrice()), "", "&7\u25b8 &fStock: " + (String)(item.getStock() == -1 ? "&aUnlimited" : "&e" + item.getStock()), "", "&e&l\u26a1 ACTIONS:", "&a\u25b8 Left Click: &fBuy 1", "&a\u25b8 Right Click: &fSell 1", "&a\u25b8 Shift + Left: &fBuy 64", "&a\u25b8 Shift + Right: &fSell All")).addGlow(canAfford).build();
    }

    public void performSearch() {
        this.searchResults.clear();
        this.currentPage = 0;
        if (this.currentQuery.trim().isEmpty()) {
            return;
        }
        String query = this.currentQuery.toLowerCase().trim();
        Map<String, ShopSection> sections = this.plugin.getGuiManager().getSections();
        Logger.debug("Performing search for: '" + query + "'");
        for (ShopSection section : sections.values()) {
            for (ShopItem item : section.getItems()) {
                if (!this.matchesSearch(item, query)) continue;
                this.searchResults.add(item);
            }
        }
        this.searchResults.sort((a, b) -> {
            int scoreA = this.getRelevanceScore((ShopItem)a, query);
            int scoreB = this.getRelevanceScore((ShopItem)b, query);
            return Integer.compare(scoreB, scoreA);
        });
        Logger.debug("Search completed. Found " + this.searchResults.size() + " results");
    }

    private boolean matchesSearch(ShopItem item, String query) {
        String[] queryWords;
        String itemName = MessageUtils.stripColor(item.getDisplayName()).toLowerCase();
        String itemDesc = item.getDescription().toLowerCase();
        String materialName = item.getMaterial().name().toLowerCase().replace("_", " ");
        if (itemName.contains(query) || itemDesc.contains(query) || materialName.contains(query)) {
            return true;
        }
        for (String word : queryWords = query.split("\\s+")) {
            if (word.length() < 2 || !itemName.contains(word) && !itemDesc.contains(word) && !materialName.contains(word)) continue;
            return true;
        }
        if (query.length() >= 3) {
            return this.fuzzyMatch(itemName, query) || this.fuzzyMatch(materialName, query);
        }
        return false;
    }

    private boolean fuzzyMatch(String text, String query) {
        if (text.length() < query.length()) {
            return false;
        }
        int errors = 0;
        int maxErrors = Math.max(1, query.length() / 3);
        for (int i = 0; i <= text.length() - query.length(); ++i) {
            errors = 0;
            for (int j = 0; j < query.length() && (text.charAt(i + j) == query.charAt(j) || ++errors <= maxErrors); ++j) {
            }
            if (errors > maxErrors) continue;
            return true;
        }
        return false;
    }

    private int getRelevanceScore(ShopItem item, String query) {
        String itemName = MessageUtils.stripColor(item.getDisplayName()).toLowerCase();
        String materialName = item.getMaterial().name().toLowerCase().replace("_", " ");
        int score = 0;
        if (itemName.equals(query)) {
            score += 100;
        } else if (itemName.startsWith(query)) {
            score += 80;
        } else if (itemName.contains(query)) {
            score += 60;
        }
        if (materialName.equals(query)) {
            score += 90;
        } else if (materialName.startsWith(query)) {
            score += 70;
        } else if (materialName.contains(query)) {
            score += 50;
        }
        if (item.getDescription().toLowerCase().contains(query)) {
            score += 30;
        }
        return score;
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(45, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK TO SHOP").setLore(Arrays.asList("&7\u25b8 &fReturn to main shop", "", "&a&l\u27a4 &aClick to go back!")).build());
        if (!this.currentQuery.isEmpty()) {
            gui.setItem(46, new ItemBuilder(Material.BARRIER).setName("&c&l\u2716 &e&lCLEAR SEARCH").setLore(Arrays.asList("&7\u25b8 &fClear current search", "&7\u25b8 &fStart new search", "", "&c&l\u27a4 &cClick to clear!")).build());
        }
        if (this.currentPage > 0) {
            gui.setItem(48, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2190 &e&lPREVIOUS PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + this.currentPage + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to go back!")).build());
        }
        if (this.hasNextPage()) {
            gui.setItem(50, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2192 &e&lNEXT PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + (this.currentPage + 2) + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to continue!")).build());
        }
        gui.setItem(53, new ItemBuilder(Material.KNOWLEDGE_BOOK).setName("&b&l\ud83d\udca1 &e&lSEARCH TIPS").setLore(Arrays.asList("&7\u25b8 &fType in chat to search", "&7\u25b8 &fPartial words work", "&7\u25b8 &fTypos are forgiven", "&7\u25b8 &fUse material names", "", "&b&l\ud83d\udcdd &bExamples:", "&7  \u2022 &f'dia' \u2192 diamonds", "&7  \u2022 &f'iro' \u2192 iron items", "&7  \u2022 &f'foo' \u2192 food items")).build());
    }

    public void quickSearch(String query) {
        this.currentQuery = query;
        this.performSearch();
        this.open();
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.currentPage;
            this.open();
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.open();
        }
    }

    public void clearSearch() {
        this.currentQuery = "";
        this.searchResults.clear();
        this.currentPage = 0;
        this.open();
    }

    private int getTotalPages() {
        return Math.max(1, (int)Math.ceil((double)this.searchResults.size() / 28.0));
    }

    private boolean hasNextPage() {
        return this.currentPage + 1 < this.getTotalPages();
    }

    public List<ShopItem> getSearchResults() {
        return this.searchResults;
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }
}

