/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.Logger;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SectionGui {
    private final EasyShopGUI plugin;
    private final Player player;
    private final ShopSection section;
    private int currentPage = 0;

    public SectionGui(EasyShopGUI plugin, Player player, ShopSection section) {
        this.plugin = plugin;
        this.player = player;
        this.section = section;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MessageUtils.colorize("&6&l\u2726 " + this.section.getDisplayName() + " &6&l\u2726"));
        this.fillBackground(gui);
        this.addSectionItems(gui);
        this.addNavigation(gui);
        this.addPlayerInfo(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        gui.clear();
        Logger.debug("Filling background for section: " + this.section.getId());
        ItemStack background = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
    }

    private void addSectionItems(Inventory gui) {
        List<ShopItem> items = this.section.getItems();
        Logger.debug("Adding " + items.size() + " items to section GUI for: " + this.section.getId());
        int startIndex = this.currentPage * 28;
        int[] itemSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = 0; i < itemSlots.length && startIndex + i < items.size(); ++i) {
            ShopItem item = items.get(startIndex + i);
            Logger.debug("Adding item to slot " + itemSlots[i] + ": " + item.getDisplayName());
            gui.setItem(itemSlots[i], this.createShopItemStack(item));
        }
    }

    private ItemStack createShopItemStack(ShopItem item) {
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        double currentBuyPrice = this.plugin.getAiMarketplace().getCurrentBuyPrice(item.getId());
        double currentSellPrice = this.plugin.getAiMarketplace().getCurrentSellPrice(item.getId());
        int currentStock = this.plugin.getAiMarketplace().getCurrentStock(item.getId());
        if (currentBuyPrice <= 0.0) {
            currentBuyPrice = item.getBuyPrice();
        }
        if (currentSellPrice <= 0.0) {
            currentSellPrice = item.getSellPrice();
        }
        if (currentStock == 0) {
            currentStock = item.getStock();
        }
        boolean canAfford = balance >= currentBuyPrice;
        boolean inStock = currentStock == -1 || currentStock > 0;
        Logger.debug("Creating item stack for: " + item.getDisplayName() + " (Material: " + String.valueOf(item.getMaterial()) + ")");
        return new ItemBuilder(item.getMaterial()).setName(item.getDisplayName()).setLore(Arrays.asList("&7\u25b8 &fDescription:", "&7  " + item.getDescription(), "", "&7\u25b8 &fPricing:", "&a  Buy: &f$" + String.format("%.2f", currentBuyPrice) + (canAfford && inStock ? " &a\u2713" : " &c\u2717"), "&c  Sell: &f$" + String.format("%.2f", currentSellPrice), "", "&7\u25b8 &fStock: " + (String)(currentStock == -1 ? "&aUnlimited" : (inStock ? "&e" + currentStock : "&c0 - OUT OF STOCK")), "&7\u25b8 &fDemand: " + this.getDemandColor(item.getDemand()) + item.getDemand().toUpperCase(), "", "&e&l\u26a1 QUICK ACTIONS:", "&a\u25b8 Left Click: &fBuy 1", "&a\u25b8 Right Click: &fSell 1", "&a\u25b8 Shift + Left: &fBuy 64", "&a\u25b8 Shift + Right: &fSell All", "&a\u25b8 Middle Click: &fView Details")).addGlow(canAfford && inStock).build();
    }

    private String getDemandColor(String demand) {
        switch (demand.toLowerCase()) {
            case "high": {
                return "&c";
            }
            case "medium": {
                return "&e";
            }
            case "low": {
                return "&a";
            }
        }
        return "&7";
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(0, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK TO SHOP").setLore(Arrays.asList("&7\u25b8 &fReturn to main shop", "", "&a&l\u27a4 &aClick to go back!")).build());
        if (this.currentPage > 0) {
            gui.setItem(45, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2190 &e&lPREVIOUS PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + this.currentPage + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to go back!")).build());
        }
        if (this.hasNextPage()) {
            gui.setItem(53, new ItemBuilder(Material.SPECTRAL_ARROW).setName("&e&l\u2192 &e&lNEXT PAGE").setLore(Arrays.asList("&7\u25b8 &fPage " + (this.currentPage + 2) + " of " + this.getTotalPages(), "", "&a&l\u27a4 &aClick to continue!")).build());
        }
        gui.setItem(49, new ItemBuilder(Material.BOOK).setName("&6&l\ud83d\udcd6 &e&lPAGE INFO").setLore(Arrays.asList("&7\u25b8 &fCurrent Page: &a" + (this.currentPage + 1), "&7\u25b8 &fTotal Pages: &a" + this.getTotalPages(), "&7\u25b8 &fTotal Items: &a" + this.section.getItems().size(), "&7\u25b8 &fItems on Page: &a" + this.getItemsOnCurrentPage())).build());
    }

    private void addPlayerInfo(Inventory gui) {
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        gui.setItem(4, new ItemBuilder(Material.PLAYER_HEAD).setName("&6&l\ud83d\udc64 &e&l" + this.player.getName().toUpperCase()).setLore(Arrays.asList("&7\u25b8 &fBalance: &a$" + String.format("%.2f", balance), "&7\u25b8 &fSection: &e" + this.section.getName(), "&7\u25b8 &fPermissions: " + (this.player.hasPermission("easyshopgui.vip") ? "&aVIP" : "&7Default"), "", "&7\u25b8 &fDiscount: " + this.getPlayerDiscount() + "%", "&7\u25b8 &fSell Multiplier: " + this.getSellMultiplier() + "x")).setSkullOwner(this.player.getName()).build());
        gui.setItem(8, new ItemBuilder(Material.EMERALD).setName("&a&l\ud83d\udc8e &e&lQUICK ACTIONS").setLore(Arrays.asList("&7\u25b8 &fAvailable actions:", "&a  \u2022 &fBuy in bulk", "&a  \u2022 &fSell inventory", "&a  \u2022 &fPrice alerts", "&a  \u2022 &fWishlist items", "", "&a&l\u27a4 &aClick for options!")).addGlow().build());
    }

    private int getTotalPages() {
        return Math.max(1, (int)Math.ceil((double)this.section.getItems().size() / 28.0));
    }

    private boolean hasNextPage() {
        return this.currentPage + 1 < this.getTotalPages();
    }

    private int getItemsOnCurrentPage() {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.section.getItems().size());
        return Math.max(0, endIndex - startIndex);
    }

    private int getPlayerDiscount() {
        if (this.player.hasPermission("easyshopgui.discount.vip")) {
            return 15;
        }
        if (this.player.hasPermission("easyshopgui.discount.premium")) {
            return 10;
        }
        if (this.player.hasPermission("easyshopgui.discount.member")) {
            return 5;
        }
        return 0;
    }

    private double getSellMultiplier() {
        if (this.player.hasPermission("easyshopgui.multiplier.vip")) {
            return 1.5;
        }
        if (this.player.hasPermission("easyshopgui.multiplier.premium")) {
            return 1.3;
        }
        if (this.player.hasPermission("easyshopgui.multiplier.member")) {
            return 1.1;
        }
        return 1.0;
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.currentPage;
            this.open();
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.open();
        }
    }
}

