/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.listeners;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.utils.Logger;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class CurrencyListener
implements Listener {
    private final EasyShopGUI plugin;

    public CurrencyListener(EasyShopGUI plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (this.plugin.getPaperCurrency().isCheque(item)) {
            event.setCancelled(true);
            boolean success = this.plugin.getPaperCurrency().redeemCheque(player, item);
            if (success) {
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            } else {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent event) {
        String inventoryTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && this.plugin.getPaperCurrency().isCheque(clickedItem) && ((inventoryTitle = event.getView().getTitle()).contains("Shopkeeper") || inventoryTitle.contains("Trading") || inventoryTitle.contains("Shop") || inventoryTitle.contains("Trade"))) {
            Logger.debug("Cheque being used in trading interface: " + inventoryTitle);
        }
    }
}

