/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.utils;

import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta meta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder(ItemStack item) {
        this.item = item.clone();
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder setName(String name) {
        if (this.meta != null) {
            this.meta.setDisplayName(MessageUtils.colorize(name));
        }
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        if (this.meta != null) {
            this.meta.setLore(MessageUtils.colorize(lore));
        }
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore(Arrays.asList(lore));
    }

    public ItemBuilder addLore(String line) {
        if (this.meta != null) {
            List<String> lore = this.meta.getLore();
            if (lore == null) {
                lore = Arrays.asList(MessageUtils.colorize(line));
            } else {
                lore.add(MessageUtils.colorize(line));
            }
            this.meta.setLore(lore);
        }
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(Math.max(1, Math.min(amount, 64)));
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        if (this.meta != null) {
            this.meta.addEnchant(enchantment, level, true);
        }
        return this;
    }

    public ItemBuilder addGlow() {
        return this.addGlow(true);
    }

    public ItemBuilder addGlow(boolean condition) {
        if (condition && this.meta != null) {
            this.meta.addEnchant(Enchantment.LURE, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public ItemBuilder setSkullOwner(String owner) {
        if (this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwner(owner);
        }
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        if (this.meta != null) {
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        if (this.meta != null) {
            this.meta.setUnbreakable(unbreakable);
        }
        return this;
    }

    public ItemStack build() {
        if (this.meta != null) {
            this.item.setItemMeta(this.meta);
        }
        return this.item;
    }
}

