/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.resourcebarapi;

import com.github.theredbrain.resourcebarapi.ResourceBarAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.apache.commons.lang3.tuple.MutablePair;

@Environment(value=EnvType.CLIENT)
public class ResourceBarAPIClient
implements ClientModInitializer {
    private static final int CACHED_VALUE_ARRAY_LENGTH = 15;
    private static final int CACHED_TEXTURE_ID_ARRAY_LENGTH = 8;
    public static Map<String, double[]> CACHED_RESOURCE_BAR_VALUES = new HashMap<String, double[]>();
    public static Map<String, class_2960[]> CACHED_RESOURCE_BAR_TEXTURE_IDS = new HashMap<String, class_2960[]>();

    public void onInitializeClient() {
    }

    public static void clearCache(String identifier_string, double[] cached_values_default, class_2960[] cached_textures_default) {
        CACHED_RESOURCE_BAR_VALUES.put(identifier_string, cached_values_default);
        CACHED_RESOURCE_BAR_TEXTURE_IDS.put(identifier_string, cached_textures_default);
    }

    public static void drawIconResourceBar(class_310 client, class_332 context, String identifier_string, double current_value, double max_value, class_2960 container_texture_id, class_2960 full_texture_id, class_2960 half_texture_id, List<ResourceBarAPI.AdditionalIconType> additional_affix_values, List<ResourceBarAPI.AdditionalIconType> additional_prefix_values, int origin_x, int origin_y, int offset_x, int offset_y, ResourceBarAPI.ResourceBarFillDirection resource_bar_fill_direction, boolean reverse_stack_direction, int max_icon_amount_per_bar) {
        block12: {
            int bar_x;
            int bar_y;
            int i;
            block15: {
                block14: {
                    block13: {
                        i = (int)(max_value + 0.5) / 2;
                        if (i == 0) break block12;
                        bar_y = origin_y + offset_y;
                        bar_x = origin_x + offset_x;
                        if (resource_bar_fill_direction != ResourceBarAPI.ResourceBarFillDirection.LEFT_TO_RIGHT) break block13;
                        int m = bar_y;
                        int n = 0;
                        while (i > 0) {
                            int o = Math.min(i, max_icon_amount_per_bar);
                            i -= o;
                            for (int p = 0; p < o; ++p) {
                                int q = bar_x + p * 8;
                                context.method_52706(class_10799.field_56883, container_texture_id, q, m, 9, 9);
                                if ((double)(p * 2 + 1 + n) < current_value) {
                                    context.method_52706(class_10799.field_56883, full_texture_id, q, m, 9, 9);
                                }
                                if ((double)(p * 2 + 1 + n) != current_value) continue;
                                context.method_52706(class_10799.field_56883, half_texture_id, q, m, 9, 9);
                            }
                            m = reverse_stack_direction ? (m -= 10) : (m += 10);
                            n += max_icon_amount_per_bar * 2;
                        }
                        break block12;
                    }
                    if (resource_bar_fill_direction != ResourceBarAPI.ResourceBarFillDirection.RIGHT_TO_LEFT) break block14;
                    int m = bar_y;
                    int n = 0;
                    while (i > 0) {
                        int o = Math.min(i, max_icon_amount_per_bar);
                        i -= o;
                        for (int p = 0; p < o; ++p) {
                            int q = bar_x - p * 8 - 9;
                            context.method_52706(class_10799.field_56883, container_texture_id, q, m, 9, 9);
                            if ((double)(p * 2 + 1 + n) < current_value) {
                                context.method_52706(class_10799.field_56883, full_texture_id, q, m, 9, 9);
                            }
                            if ((double)(p * 2 + 1 + n) != current_value) continue;
                            context.method_52706(class_10799.field_56883, half_texture_id, q, m, 9, 9);
                        }
                        m = reverse_stack_direction ? (m -= 10) : (m += 10);
                        n += max_icon_amount_per_bar * 2;
                    }
                    break block12;
                }
                if (resource_bar_fill_direction != ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM) break block15;
                int n = bar_x;
                int m = 0;
                while (i > 0) {
                    int o = Math.min(i, max_icon_amount_per_bar);
                    i -= o;
                    for (int p = 0; p < o; ++p) {
                        int q = bar_y + p * 8;
                        context.method_52706(class_10799.field_56883, container_texture_id, n, q, 9, 9);
                        if ((double)(p * 2 + 1 + m) < current_value) {
                            context.method_52706(class_10799.field_56883, full_texture_id, n, q, 9, 9);
                        }
                        if ((double)(p * 2 + 1 + m) != current_value) continue;
                        context.method_52706(class_10799.field_56883, half_texture_id, n, q, 9, 9);
                    }
                    n = reverse_stack_direction ? (n -= 10) : (n += 10);
                    m += max_icon_amount_per_bar * 2;
                }
                break block12;
            }
            if (resource_bar_fill_direction != ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP) break block12;
            int n = bar_x;
            int m = 0;
            while (i > 0) {
                int o = Math.min(i, max_icon_amount_per_bar);
                i -= o;
                for (int p = 0; p < o; ++p) {
                    int q = bar_y - p * 8 - 9;
                    context.method_52706(class_10799.field_56883, container_texture_id, n, q, 9, 9);
                    if ((double)(p * 2 + 1 + m) < current_value) {
                        context.method_52706(class_10799.field_56883, full_texture_id, n, q, 9, 9);
                    }
                    if ((double)(p * 2 + 1 + m) != current_value) continue;
                    context.method_52706(class_10799.field_56883, half_texture_id, n, q, 9, 9);
                }
                n = reverse_stack_direction ? (n -= 10) : (n += 10);
                m += max_icon_amount_per_bar * 2;
            }
        }
    }

    public static void drawSmoothResourceBar(class_310 client, class_332 context, String identifier_string, double[] cached_values_default, class_2960[] cached_texture_ids_default, double current_value, double max_value, int current_value_reduction, double current_unreserved_value, int origin_x, int origin_y, ValidatedMap<Integer, Integer> element_offsets_x, ValidatedMap<Integer, Integer> element_offsets_y, int additional_offset_x, int additional_offset_y, ResourceBarAPI.ResourceBarFillDirection resource_bar_fill_direction, ValidatedMap<Integer, Integer> background_texture_heights, ValidatedMap<Integer, Integer> background_texture_widths, ValidatedMap<Integer, class_2960> background_texture_ids, int progress_offset_x, int progress_offset_y, ValidatedMap<Integer, Integer> progress_texture_heights, ValidatedMap<Integer, Integer> progress_texture_widths, ValidatedMap<Integer, class_2960> progress_decrease_animation_texture_ids, ValidatedMap<Integer, class_2960> progress_increase_animation_texture_ids, ValidatedMap<Integer, class_2960> progress_increase_value_texture_ids, ValidatedMap<Integer, class_2960> progress_texture_ids, int reserved_offset_x, int reserved_offset_y, ValidatedMap<Integer, Integer> reserved_texture_heights, ValidatedMap<Integer, Integer> reserved_texture_widths, ValidatedMap<Integer, class_2960> reserved_texture_ids, boolean show_current_value_overlay, int overlay_offset_x, int overlay_offset_y, ValidatedMap<Integer, Integer> overlay_texture_heights, ValidatedMap<Integer, Integer> overlay_texture_widths, ValidatedMap<Integer, class_2960> overlay_texture_ids, boolean show_icon, int icon_offset_x, int icon_offset_y, ValidatedMap<Integer, Integer> icon_texture_heights, ValidatedMap<Integer, Integer> icon_texture_widths, ValidatedMap<Integer, class_2960> icon_texture_ids, boolean enable_smooth_animation, int animation_interval, boolean max_value_change_is_animated) {
        boolean reduceOldRatio;
        int reservedBarLength;
        int progressBarLength;
        class_2960[] cachedTextureIds;
        if (cached_values_default.length != 15) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("wrong default cached values array length, needs to be 15, is: " + cached_values_default.length);
            }
            return;
        }
        if (cached_texture_ids_default.length != 8) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("wrong default cached values array length, needs to be 8, is: " + cached_texture_ids_default.length);
            }
            return;
        }
        double[] cachedValues = CACHED_RESOURCE_BAR_VALUES.getOrDefault(identifier_string, cached_values_default);
        if (cachedValues.length != 15) {
            cachedValues = cached_values_default;
        }
        if ((cachedTextureIds = CACHED_RESOURCE_BAR_TEXTURE_IDS.getOrDefault(identifier_string, cached_texture_ids_default)).length != 8) {
            cachedTextureIds = cached_texture_ids_default;
        }
        double oldMaxBuildUp = cachedValues[0];
        int oldNormalizedResourceRatio = (int)cachedValues[1];
        int resourceBarAnimationCounter = (int)cachedValues[2];
        int element_offset_x = (int)cachedValues[3];
        int element_offset_y = (int)cachedValues[4];
        int background_texture_height = (int)cachedValues[5];
        int background_texture_width = (int)cachedValues[6];
        int progress_texture_height = (int)cachedValues[7];
        int progress_texture_width = (int)cachedValues[8];
        int reserved_texture_height = (int)cachedValues[9];
        int reserved_texture_width = (int)cachedValues[10];
        int overlay_texture_height = (int)cachedValues[11];
        int overlay_texture_width = (int)cachedValues[12];
        int icon_texture_height = (int)cachedValues[13];
        int icon_texture_width = (int)cachedValues[14];
        class_2960 background_texture_id = cachedTextureIds[0];
        class_2960 progress_decrease_animation_texture_id = cachedTextureIds[1];
        class_2960 progress_increase_animation_texture_id = cachedTextureIds[2];
        class_2960 progress_increase_value_texture_id = cachedTextureIds[3];
        class_2960 progress_texture_id = cachedTextureIds[4];
        class_2960 reserved_texture_id = cachedTextureIds[5];
        class_2960 overlay_texture_id = cachedTextureIds[6];
        class_2960 icon_texture_id = cachedTextureIds[7];
        boolean recalculate_cache = false;
        if (oldMaxBuildUp != max_value) {
            oldMaxBuildUp = max_value;
            recalculate_cache = true;
            int current_threshold = 0;
            ArrayList list = new ArrayList(element_offsets_x.keySet());
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                element_offset_x = (Integer)element_offsets_x.getOrDefault((Object)threshold, (Object)((int)cached_values_default[3]));
                current_threshold = threshold;
            }
            list = new ArrayList(element_offsets_y.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                element_offset_y = (Integer)element_offsets_y.getOrDefault((Object)threshold, (Object)((int)cached_values_default[4]));
                current_threshold = threshold;
            }
            list = new ArrayList(background_texture_heights.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                background_texture_height = (Integer)background_texture_heights.getOrDefault((Object)threshold, (Object)((int)cached_values_default[5]));
                current_threshold = threshold;
            }
            list = new ArrayList(background_texture_widths.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                background_texture_width = (Integer)background_texture_widths.getOrDefault((Object)threshold, (Object)((int)cached_values_default[6]));
                current_threshold = threshold;
            }
            list = new ArrayList(progress_texture_heights.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_texture_height = (Integer)progress_texture_heights.getOrDefault((Object)threshold, (Object)((int)cached_values_default[7]));
                current_threshold = threshold;
            }
            list = new ArrayList(progress_texture_widths.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_texture_width = (Integer)progress_texture_widths.getOrDefault((Object)threshold, (Object)((int)cached_values_default[8]));
                current_threshold = threshold;
            }
            list = new ArrayList(reserved_texture_heights.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                reserved_texture_height = (Integer)reserved_texture_heights.getOrDefault((Object)threshold, (Object)((int)cached_values_default[9]));
                current_threshold = threshold;
            }
            list = new ArrayList(reserved_texture_widths.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                reserved_texture_width = (Integer)reserved_texture_widths.getOrDefault((Object)threshold, (Object)((int)cached_values_default[10]));
                current_threshold = threshold;
            }
            list = new ArrayList(overlay_texture_heights.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                overlay_texture_height = (Integer)overlay_texture_heights.getOrDefault((Object)threshold, (Object)((int)cached_values_default[11]));
                current_threshold = threshold;
            }
            list = new ArrayList(overlay_texture_widths.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                overlay_texture_width = (Integer)overlay_texture_widths.getOrDefault((Object)threshold, (Object)((int)cached_values_default[12]));
                current_threshold = threshold;
            }
            list = new ArrayList(icon_texture_heights.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                icon_texture_height = (Integer)icon_texture_heights.getOrDefault((Object)threshold, (Object)((int)cached_values_default[13]));
                current_threshold = threshold;
            }
            list = new ArrayList(icon_texture_widths.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                icon_texture_width = (Integer)icon_texture_widths.getOrDefault((Object)threshold, (Object)((int)cached_values_default[14]));
                current_threshold = threshold;
            }
            list = new ArrayList(background_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                background_texture_id = (class_2960)background_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[0]);
                current_threshold = threshold;
            }
            list = new ArrayList(progress_decrease_animation_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_decrease_animation_texture_id = (class_2960)progress_decrease_animation_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[1]);
                current_threshold = threshold;
            }
            list = new ArrayList(progress_increase_animation_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_increase_animation_texture_id = (class_2960)progress_increase_animation_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[2]);
                current_threshold = threshold;
            }
            list = new ArrayList(progress_increase_value_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_increase_value_texture_id = (class_2960)progress_increase_value_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[3]);
                current_threshold = threshold;
            }
            list = new ArrayList(progress_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                progress_texture_id = (class_2960)progress_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[4]);
                current_threshold = threshold;
            }
            list = new ArrayList(reserved_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                reserved_texture_id = (class_2960)reserved_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[5]);
                current_threshold = threshold;
            }
            list = new ArrayList(overlay_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                overlay_texture_id = (class_2960)overlay_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[6]);
                current_threshold = threshold;
            }
            list = new ArrayList(icon_texture_ids.keySet());
            current_threshold = 0;
            for (Integer threshold : list) {
                if (!(max_value >= (double)threshold.intValue()) || threshold < current_threshold) continue;
                icon_texture_id = (class_2960)icon_texture_ids.getOrDefault((Object)threshold, (Object)cached_texture_ids_default[7]);
                current_threshold = threshold;
            }
        }
        if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP || resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM) {
            progressBarLength = progress_texture_height;
            reservedBarLength = reserved_texture_height;
        } else {
            progressBarLength = progress_texture_width;
            reservedBarLength = reserved_texture_width;
        }
        int normalizedResourceRatio = (int)(current_value / Math.max(max_value, 1.0) * (double)progressBarLength);
        double currentReservedValue = max_value - current_unreserved_value;
        int normalizedReservedResourceRatio = (int)(currentReservedValue / Math.max(max_value, 1.0) * (double)reservedBarLength);
        if (recalculate_cache && !max_value_change_is_animated) {
            oldNormalizedResourceRatio = normalizedResourceRatio;
        }
        boolean bl = reduceOldRatio = oldNormalizedResourceRatio > normalizedResourceRatio;
        if (oldNormalizedResourceRatio != normalizedResourceRatio && (resourceBarAnimationCounter += Math.max(1, current_value_reduction)) > Math.max(0, animation_interval)) {
            oldNormalizedResourceRatio += reduceOldRatio ? -1 : 1;
            resourceBarAnimationCounter = 0;
        }
        CACHED_RESOURCE_BAR_VALUES.put(identifier_string, new double[]{oldMaxBuildUp, oldNormalizedResourceRatio, resourceBarAnimationCounter, element_offset_x, element_offset_y, background_texture_height, background_texture_width, progress_texture_height, progress_texture_width, reserved_texture_height, reserved_texture_width, overlay_texture_height, overlay_texture_width, icon_texture_height, icon_texture_width});
        CACHED_RESOURCE_BAR_TEXTURE_IDS.put(identifier_string, new class_2960[]{background_texture_id, progress_decrease_animation_texture_id, progress_increase_animation_texture_id, progress_increase_value_texture_id, progress_texture_id, reserved_texture_id, overlay_texture_id, icon_texture_id});
        int elementX = origin_x + element_offset_x + additional_offset_x;
        int elementY = origin_y + element_offset_y + additional_offset_y;
        if (background_texture_id == null) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("background texture id == null");
            }
        } else if (background_texture_width <= 0 && background_texture_height <= 0) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("invalid background texture dimensions");
            }
        } else {
            context.method_25290(class_10799.field_56883, background_texture_id, elementX, elementY, 0.0f, 0.0f, background_texture_width, background_texture_height, background_texture_width, background_texture_height);
        }
        int progressElementX = elementX + progress_offset_x;
        int progressElementY = elementY + progress_offset_y;
        if (enable_smooth_animation) {
            if (reduceOldRatio) {
                if (oldNormalizedResourceRatio > 0) {
                    ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, progress_decrease_animation_texture_id, identifier_string + "_reduce_animation", resource_bar_fill_direction, progressElementX, progressElementY, progress_texture_width, progress_texture_height, normalizedResourceRatio, oldNormalizedResourceRatio);
                }
                if (normalizedResourceRatio > 0) {
                    ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, progress_texture_id, identifier_string + "_reduce_value", resource_bar_fill_direction, progressElementX, progressElementY, progress_texture_width, progress_texture_height, 0, normalizedResourceRatio);
                }
            } else {
                if (normalizedResourceRatio > 0) {
                    ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, progress_increase_value_texture_id, identifier_string + "_increase_value", resource_bar_fill_direction, progressElementX, progressElementY, progress_texture_width, progress_texture_height, oldNormalizedResourceRatio, normalizedResourceRatio);
                }
                if (oldNormalizedResourceRatio > 0) {
                    ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, progress_increase_animation_texture_id, identifier_string + "_increase_animation", resource_bar_fill_direction, progressElementX, progressElementY, progress_texture_width, progress_texture_height, 0, oldNormalizedResourceRatio);
                }
            }
        } else if (normalizedResourceRatio > 0) {
            ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, progress_texture_id, identifier_string + "_progress_no_animation", resource_bar_fill_direction, progressElementX, progressElementY, progress_texture_width, progress_texture_height, 0, normalizedResourceRatio);
        }
        if (normalizedReservedResourceRatio > 0) {
            int reservedElementX = elementX + reserved_offset_x;
            int reservedElementY = elementY + reserved_offset_y;
            ResourceBarAPIClient.drawResourceBarDynamicFourDirectionalLayer(client, context, reserved_texture_id, identifier_string + "_reserved", resource_bar_fill_direction, reservedElementX, reservedElementY, reserved_texture_width, reserved_texture_height, reservedBarLength - normalizedReservedResourceRatio, reservedBarLength);
        }
        if (show_current_value_overlay && normalizedResourceRatio > 0) {
            if (overlay_texture_id == null) {
                if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                    ResourceBarAPI.LOGGER.info("overlay texture id == null");
                }
            } else if (overlay_texture_width <= 0 || overlay_texture_height <= 0) {
                if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                    ResourceBarAPI.LOGGER.info("invalid overlay texture dimensions");
                }
            } else {
                int overlayElementX = progressElementX + overlay_offset_x;
                int overlayElementY = progressElementY + overlay_offset_y;
                if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP) {
                    if (current_value > 0.0 && current_value < max_value) {
                        context.method_25290(class_10799.field_56883, overlay_texture_id, overlayElementX, overlayElementY + progressBarLength - normalizedResourceRatio, 0.0f, 0.0f, overlay_texture_width, overlay_texture_height, overlay_texture_width, overlay_texture_height);
                    }
                } else if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.RIGHT_TO_LEFT) {
                    if (current_value > 0.0 && current_value < max_value) {
                        context.method_25290(class_10799.field_56883, overlay_texture_id, overlayElementX + progressBarLength - normalizedResourceRatio, overlayElementY, 0.0f, 0.0f, overlay_texture_width, overlay_texture_height, overlay_texture_width, overlay_texture_height);
                    }
                } else if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM) {
                    if (current_value > 0.0 && current_value < max_value) {
                        context.method_25290(class_10799.field_56883, overlay_texture_id, overlayElementX, overlayElementY + normalizedResourceRatio, 0.0f, 0.0f, overlay_texture_width, overlay_texture_height, overlay_texture_width, overlay_texture_height);
                    }
                } else if (current_value > 0.0 && current_value < max_value) {
                    context.method_25290(class_10799.field_56883, overlay_texture_id, overlayElementX + normalizedResourceRatio, overlayElementY, 0.0f, 0.0f, overlay_texture_width, overlay_texture_height, overlay_texture_width, overlay_texture_height);
                }
            }
        }
        if (show_icon) {
            if (icon_texture_id == null) {
                if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                    ResourceBarAPI.LOGGER.info("icon texture id == null");
                }
            } else if (icon_texture_width <= 0 || icon_texture_height <= 0) {
                if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                    ResourceBarAPI.LOGGER.info("invalid icon texture dimensions");
                }
            } else {
                context.method_25290(class_10799.field_56883, icon_texture_id, origin_x + icon_offset_x, origin_y + icon_offset_y, 0.0f, 0.0f, icon_texture_width, icon_texture_height, icon_texture_width, icon_texture_height);
            }
        }
    }

    public static void drawResourceNumber(class_310 client, class_327 textRenderer, class_332 context, String identifier_string, double current_value, double max_value, double current_unreserved_value, int origin_x, int origin_y, boolean show_max_value, int number_offset_x, int number_offset_y, int resource_bar_number_color) {
        int displayed_current_value = (int)Math.round(current_value);
        int displayed_max_value = (int)Math.round(max_value);
        int displayed_current_unreserved_value = (int)Math.round(current_unreserved_value);
        String resourceBarNumberString = show_max_value ? (current_unreserved_value < max_value ? displayed_current_value + "/" + displayed_current_unreserved_value + " (" + displayed_max_value + ")" : displayed_current_value + "/" + displayed_max_value) : String.valueOf(displayed_current_value);
        int resourceBarNumberX = origin_x - textRenderer.method_1727(resourceBarNumberString) / 2 + number_offset_x;
        int resourceBarNumberY = origin_y + number_offset_y;
        context.method_51433(textRenderer, resourceBarNumberString, resourceBarNumberX + 1, resourceBarNumberY, 0, false);
        context.method_51433(textRenderer, resourceBarNumberString, resourceBarNumberX - 1, resourceBarNumberY, 0, false);
        context.method_51433(textRenderer, resourceBarNumberString, resourceBarNumberX, resourceBarNumberY + 1, 0, false);
        context.method_51433(textRenderer, resourceBarNumberString, resourceBarNumberX, resourceBarNumberY - 1, 0, false);
        context.method_51433(textRenderer, resourceBarNumberString, resourceBarNumberX, resourceBarNumberY, resource_bar_number_color, false);
    }

    private static ResourceBarAPI.ResourceBarFillDirection getOppositeFillDirection(ResourceBarAPI.ResourceBarFillDirection fillDirection) {
        if (fillDirection == ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP) {
            return ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM;
        }
        if (fillDirection == ResourceBarAPI.ResourceBarFillDirection.RIGHT_TO_LEFT) {
            return ResourceBarAPI.ResourceBarFillDirection.LEFT_TO_RIGHT;
        }
        if (fillDirection == ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM) {
            return ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP;
        }
        return ResourceBarAPI.ResourceBarFillDirection.RIGHT_TO_LEFT;
    }

    public static MutablePair<Integer, Integer> getOriginPos(class_332 drawContext, ResourceBarAPI.ResourceBarOrigin origin) {
        int originY;
        int originX;
        if (origin == ResourceBarAPI.ResourceBarOrigin.TOP_MIDDLE) {
            originX = drawContext.method_51421() / 2;
            originY = 0;
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.TOP_RIGHT) {
            originX = drawContext.method_51421();
            originY = 0;
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.MIDDLE_LEFT) {
            originX = 0;
            originY = drawContext.method_51443() / 2;
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.MIDDLE_MIDDLE) {
            originX = drawContext.method_51421() / 2;
            originY = drawContext.method_51443() / 2;
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.MIDDLE_RIGHT) {
            originX = drawContext.method_51421();
            originY = drawContext.method_51443() / 2;
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.BOTTOM_LEFT) {
            originX = 0;
            originY = drawContext.method_51443();
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.BOTTOM_MIDDLE) {
            originX = drawContext.method_51421() / 2;
            originY = drawContext.method_51443();
        } else if (origin == ResourceBarAPI.ResourceBarOrigin.BOTTOM_RIGHT) {
            originX = drawContext.method_51421();
            originY = drawContext.method_51443();
        } else {
            originX = 0;
            originY = 0;
        }
        return new MutablePair((Object)originX, (Object)originY);
    }

    private static void drawResourceBarDynamicFourDirectionalLayer(class_310 client, class_332 context, class_2960 texture_id, String identifier_string, ResourceBarAPI.ResourceBarFillDirection resource_bar_fill_direction, int layer_x, int layer_y, int texture_width, int texture_height, int start_display, int end_display) {
        if (texture_id == null) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("texture id == null");
            }
            return;
        }
        if (texture_width <= 0 || texture_height <= 0) {
            if (ResourceBarAPI.SERVER_CONFIG.show_debug_log) {
                ResourceBarAPI.LOGGER.info("invalid texture dimensions");
            }
            return;
        }
        if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.BOTTOM_TO_TOP) {
            context.method_25290(class_10799.field_56883, texture_id, layer_x, layer_y + texture_height - end_display, 0.0f, (float)(texture_height - end_display), texture_width, end_display - start_display, texture_width, texture_height);
        } else if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.RIGHT_TO_LEFT) {
            context.method_25290(class_10799.field_56883, texture_id, layer_x + texture_width - end_display, layer_y, (float)(texture_width - end_display), 0.0f, end_display - start_display, texture_height, texture_width, texture_height);
        } else if (resource_bar_fill_direction == ResourceBarAPI.ResourceBarFillDirection.TOP_TO_BOTTOM) {
            context.method_25290(class_10799.field_56883, texture_id, layer_x, layer_y + start_display, 0.0f, (float)start_display, texture_width, end_display - start_display, texture_width, texture_height);
        } else {
            context.method_25290(class_10799.field_56883, texture_id, layer_x + start_display, layer_y, (float)start_display, 0.0f, end_display - start_display, texture_height, texture_width, texture_height);
        }
    }
}

