/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla;

import com.mojang.brigadier.CommandDispatcher;
import com.tristankechlo.improvedvanilla.commands.ImprovedVanillaCommand;
import com.tristankechlo.improvedvanilla.config.ConfigManager;
import com.tristankechlo.improvedvanilla.eventhandler.CropRightClickHandler;
import com.tristankechlo.improvedvanilla.eventhandler.EasyPlantingHandler;
import com.tristankechlo.improvedvanilla.eventhandler.MobDropHandler;
import com.tristankechlo.improvedvanilla.eventhandler.SpawnerHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="improvedvanilla")
public class ForgeImprovedVanilla {
    public ForgeImprovedVanilla() {
        PlayerInteractEvent.RightClickBlock.BUS.addListener(this::cropRightClicking);
        PlayerInteractEvent.RightClickBlock.BUS.addListener(this::easyPlanting);
        LivingDropsEvent.BUS.addListener(this::mobDropHandler);
        BlockEvent.BreakEvent.BUS.addListener(this::onSpawnerBroken);
        RegisterCommandsEvent.BUS.addListener(this::registerCommands);
        ServerAboutToStartEvent.BUS.addListener(this::commonSetup);
    }

    private void commonSetup(ServerAboutToStartEvent event) {
        ConfigManager.loadAndVerifyConfig((RegistryAccess)event.getServer().registryAccess());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ImprovedVanillaCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void cropRightClicking(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = CropRightClickHandler.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        event.setCancellationResult(result);
    }

    private void easyPlanting(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = EasyPlantingHandler.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        event.setCancellationResult(result);
    }

    private void mobDropHandler(LivingDropsEvent event) {
        MobDropHandler.onMobDeath(event.getEntity().level(), event.getEntity(), event.getSource());
    }

    private void onSpawnerBroken(BlockEvent.BreakEvent event) {
        SpawnerHandler.onSpawnerBreak((Level)event.getLevel(), event.getPlayer(), event.getPos(), event.getState());
    }
}

