/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla;

import java.util.ServiceLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImprovedVanilla {
    public static final String MOD_ID = "improvedvanilla";
    public static final String MOD_NAME = "Improved Vanilla";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Improved Vanilla");

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static ItemStack getMonsterEgg(String id, int count) {
        ResourceLocation search = ResourceLocation.tryParse((String)(id + "_spawn_egg"));
        Item item = (Item)BuiltInRegistries.ITEM.getValue(search);
        if (item == null || item == Items.AIR) {
            LOGGER.warn("Did not find a spawn-egg for '{}', searched for '{}'", (Object)id, (Object)search);
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)item, count);
    }

    public static void dropItemStackInWorld(Level level, BlockPos pos, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        double d0 = (double)(level.random.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(level.random.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(level.random.nextFloat() * 0.5f) + 0.25;
        ItemEntity itementity = new ItemEntity(level, d0 + (double)pos.getX(), d1 + (double)pos.getY(), d2 + (double)pos.getZ(), stack);
        itementity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itementity);
    }
}

