/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.commands.ProjectLinks;
import com.tristankechlo.improvedvanilla.commands.ResponseHelper;
import com.tristankechlo.improvedvanilla.config.ConfigManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public final class ImprovedVanillaCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"improvedvanilla").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").requires(source -> source.hasPermission(3))).then(Commands.literal((String)"reload").executes(ImprovedVanillaCommand::configReload))).then(Commands.literal((String)"reset").executes(ImprovedVanillaCommand::configReset)))).then(Commands.literal((String)"github").executes(ProjectLinks.GITHUB::execute))).then(Commands.literal((String)"issue").executes(ProjectLinks.ISSUE::execute))).then(Commands.literal((String)"wiki").executes(ProjectLinks.WIKI::execute))).then(Commands.literal((String)"discord").executes(ProjectLinks.DISCORD::execute))).then(Commands.literal((String)"curseforge").executes(ProjectLinks.CURSEFORGE::execute))).then(Commands.literal((String)"modrinth").executes(ProjectLinks.MODRINTH::execute));
        dispatcher.register(command);
        ImprovedVanilla.LOGGER.info("Command '/{}' registered", (Object)"improvedvanilla");
    }

    private static int configReload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean success = ConfigManager.reloadConfig(((CommandSourceStack)context.getSource()).registryAccess());
        ResponseHelper.sendMessageConfigReload(source, success);
        return 1;
    }

    private static int configReset(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean success = ConfigManager.resetConfig();
        ResponseHelper.sendMessageConfigReset(source, success);
        return 1;
    }
}

