/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import com.tristankechlo.improvedvanilla.platform.IPlatformHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.core.RegistryAccess;

public final class ConfigManager {
    private static final File CONFIG_DIR = IPlatformHelper.INSTANCE.getConfigDirectory().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final String FILE_NAME = "improvedvanilla.json";
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "improvedvanilla.json");

    public static void loadAndVerifyConfig(RegistryAccess registryAccess) {
        ConfigManager.createConfigFolder();
        if (!CONFIG_FILE.exists()) {
            ImprovedVanillaConfig.setToDefault();
            ConfigManager.writeConfigToFile();
            ImprovedVanilla.LOGGER.warn("No config '{}' was found, created a new one.", (Object)FILE_NAME);
            return;
        }
        try {
            ConfigManager.loadConfigFromFile(registryAccess);
            ImprovedVanilla.LOGGER.info("Config '{}' was successfully loaded.", (Object)FILE_NAME);
        }
        catch (Exception e) {
            ImprovedVanilla.LOGGER.error(e.getMessage());
            ImprovedVanilla.LOGGER.error("Error loading config '{}', config hasn't been loaded. Using default config.", (Object)FILE_NAME);
            ImprovedVanillaConfig.setToDefault();
        }
    }

    private static void loadConfigFromFile(RegistryAccess registryAccess) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new FileReader(CONFIG_FILE));
        JsonObject json = jsonElement.getAsJsonObject();
        ImprovedVanillaConfig.deserialize((JsonElement)json, registryAccess);
    }

    private static boolean writeConfigToFile() {
        try {
            JsonElement jsonObject = ImprovedVanillaConfig.serialize();
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(CONFIG_FILE));
            writer.setIndent("\t");
            GSON.toJson(jsonObject, writer);
            writer.close();
            return true;
        }
        catch (Exception e) {
            ImprovedVanilla.LOGGER.error("There was an error writing the config to file: '{}'", (Object)FILE_NAME);
            ImprovedVanilla.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static boolean resetConfig() {
        ImprovedVanillaConfig.setToDefault();
        boolean success = ConfigManager.writeConfigToFile();
        ImprovedVanilla.LOGGER.info("Config '{}' was set to default.", (Object)FILE_NAME);
        return success;
    }

    public static boolean reloadConfig(RegistryAccess registryAccess) {
        if (CONFIG_FILE.exists()) {
            try {
                ConfigManager.loadConfigFromFile(registryAccess);
                ImprovedVanilla.LOGGER.info("The config '{}' was successfully loaded.", (Object)FILE_NAME);
                return true;
            }
            catch (Exception e) {
                ImprovedVanilla.LOGGER.error(e.getMessage());
                ImprovedVanilla.LOGGER.error("Error loading config '{}', config hasn't been loaded. Using the default config.", (Object)FILE_NAME);
                ImprovedVanillaConfig.setToDefault();
                return false;
            }
        }
        ImprovedVanillaConfig.setToDefault();
        ConfigManager.writeConfigToFile();
        ImprovedVanilla.LOGGER.warn("No config '{}' found, created a new one.", (Object)FILE_NAME);
        return true;
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder: " + CONFIG_DIR.getAbsolutePath());
        }
    }
}

