/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import com.tristankechlo.improvedvanilla.mixin.CropBlockAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public final class CropRightClickHandler {
    public static InteractionResult onPlayerRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!ImprovedVanillaConfig.get().cropRightClicking().activated()) {
            return InteractionResult.PASS;
        }
        if (player == null || level == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown() || player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Holder heldItem = BuiltInRegistries.ITEM.wrapAsHolder((Object)player.getMainHandItem().getItem());
        AtomicReference<InteractionResult.Pass> result = new AtomicReference<InteractionResult.Pass>(InteractionResult.PASS);
        if (player.getMainHandItem().isEmpty()) {
            if (!level.isClientSide()) {
                CropRightClickHandler.spawnDropsAndResetBlock(level, hitResult.getBlockPos(), 1.0f, () -> result.set((InteractionResult.Pass)InteractionResult.SUCCESS));
            }
            player.swing(hand, true);
        } else if (heldItem.is(ItemTags.HOES)) {
            if (!level.isClientSide()) {
                float multiplier = ImprovedVanillaConfig.get().cropRightClicking().modifiers().getOrDefault(heldItem, Float.valueOf(1.0f)).floatValue();
                CropRightClickHandler.spawnDropsAndResetBlock(level, hitResult.getBlockPos(), multiplier, () -> result.set((InteractionResult.Pass)InteractionResult.SUCCESS));
            }
            player.swing(hand, true);
        }
        return (InteractionResult)result.get();
    }

    private static void spawnDropsAndResetBlock(Level level, BlockPos pos, float multiplier, Runnable success) {
        Block targetBlock = level.getBlockState(pos).getBlock();
        IntegerProperty ageProperty = CropRightClickHandler.getAgeProperty(targetBlock);
        if (ageProperty == null) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        int maximumAge = (Integer)Collections.max(ageProperty.getPossibleValues());
        int currentAge = (Integer)blockState.getValue((Property)ageProperty);
        if (currentAge < maximumAge) {
            return;
        }
        BlockState newState = (BlockState)blockState.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0));
        level.setBlock(pos, newState, 3);
        List oldLoot = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
        List<ItemStack> newLoot = CropRightClickHandler.modifyLoot(oldLoot, multiplier);
        newLoot.forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
        success.run();
    }

    private static IntegerProperty getAgeProperty(Block targetBlock) {
        if (targetBlock instanceof CropBlock) {
            return ((CropBlockAccessor)targetBlock).getAgeProperty$improvedVanilla();
        }
        if (targetBlock.equals(Blocks.COCOA)) {
            return CocoaBlock.AGE;
        }
        if (targetBlock.equals(Blocks.NETHER_WART)) {
            return NetherWartBlock.AGE;
        }
        return null;
    }

    private static List<ItemStack> modifyLoot(List<ItemStack> loot, float multiplier) {
        boolean blacklistActive = ImprovedVanillaConfig.get().cropRightClicking().removeListEnabled();
        List<Ingredient> blacklist = ImprovedVanillaConfig.get().cropRightClicking().removeList();
        HashMap<Item, Integer> lootMap = new HashMap<Item, Integer>();
        loot.forEach(stack -> {
            if (blacklistActive && blacklist.stream().anyMatch(i -> i.test(stack))) {
                return;
            }
            Item item = stack.getItem();
            int amount = lootMap.getOrDefault(item, 0);
            lootMap.put(item, amount + stack.getCount());
        });
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        lootMap.forEach((item, amount) -> {
            int newAmount = Math.round((float)amount.intValue() * multiplier);
            if (newAmount <= 0) {
                return;
            }
            Consumer<ItemStack> splitter = CropRightClickHandler.createStackSplitter(newLoot::add);
            splitter.accept(new ItemStack((ItemLike)item, newAmount));
        });
        return newLoot;
    }

    private static Consumer<ItemStack> createStackSplitter(Consumer<ItemStack> consumer) {
        return stack -> {
            if (stack.getCount() < stack.getMaxStackSize()) {
                consumer.accept((ItemStack)stack);
            } else {
                ItemStack copied;
                for (int count = stack.getCount(); count > 0; count -= copied.getCount()) {
                    copied = stack.copy();
                    copied.setCount(Math.min(stack.getMaxStackSize(), count));
                    consumer.accept(copied);
                }
            }
        };
    }
}

