/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import com.tristankechlo.improvedvanilla.config.categories.EasyPlantingConfig;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class EasyPlantingHandler {
    private static final List<Item> VANILLA_SEEDS = ImmutableList.of((Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS, (Object)Items.CARROT, (Object)Items.POTATO);

    public static InteractionResult onPlayerRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!ImprovedVanillaConfig.get().easyPlanting().activated()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.getBlockPos();
        if (player == null || level == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide() || player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Block targetBlock = level.getBlockState(pos).getBlock();
        Item item = player.getMainHandItem().getItem();
        int radius = ImprovedVanillaConfig.get().easyPlanting().radius();
        if (radius <= 0 || !(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        if ((VANILLA_SEEDS.contains(item) || EasyPlantingHandler.isSeedItemForCrop(item)) && targetBlock instanceof FarmBlock) {
            EasyPlantingHandler.setCropsInRadius(radius, pos, Blocks.FARMLAND, (ServerLevel)level, (ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.NETHER_WART && targetBlock instanceof SoulSandBlock) {
            EasyPlantingHandler.setCropsInRadius(radius, pos, Blocks.SOUL_SAND, (ServerLevel)level, (ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void setCropsInRadius(int radius, BlockPos startPos, Block target, ServerLevel level, ServerPlayer player) {
        List<BlockPos> targetBlocks = EasyPlantingHandler.getTargetBlocks(radius, level, startPos, target);
        ItemStack mainHandItem = player.getMainHandItem();
        Item seedItem = player.getMainHandItem().getItem();
        BlockState blockFromSeed = ((BlockItem)seedItem).getBlock().defaultBlockState();
        boolean makeCircle = ImprovedVanillaConfig.get().easyPlanting().placingPattern() == EasyPlantingConfig.PlacingPattern.CIRCLE;
        boolean playPlantingSound = false;
        for (BlockPos pos : targetBlocks) {
            if (makeCircle && !EasyPlantingHandler.isWithInCircleDistance(startPos, pos, radius) || !EasyPlantingHandler.playerHasOneSeed(player, seedItem)) continue;
            level.setBlockAndUpdate(pos.above(), blockFromSeed);
            EasyPlantingHandler.removeOneSeedFromPlayer(player, seedItem);
            player.awardStat(Stats.ITEM_USED.get((Object)seedItem));
            CriteriaTriggers.PLACED_BLOCK.trigger(player, pos.above(), mainHandItem);
            playPlantingSound = true;
        }
        if (!playPlantingSound) {
            return;
        }
        if (mainHandItem.is(Items.NETHER_WART)) {
            level.playSound(null, (double)startPos.getX(), (double)startPos.getY(), (double)startPos.getZ(), SoundEvents.NETHER_WART_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            level.playSound(null, (double)startPos.getX(), (double)startPos.getY(), (double)startPos.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static List<BlockPos> getTargetBlocks(int radius, ServerLevel level, BlockPos startPos, Block target) {
        ArrayList<BlockPos> targetBlocks = new ArrayList<BlockPos>();
        LinkedList<Point> queue = new LinkedList<Point>();
        queue.add(new Point(startPos.getX(), startPos.getZ()));
        int minX = startPos.getX() - radius;
        int maxX = startPos.getX() + radius;
        int minY = startPos.getZ() - radius;
        int maxY = startPos.getZ() + radius;
        while (!queue.isEmpty()) {
            BlockPos current;
            Point p = (Point)queue.remove();
            if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY || !EasyPlantingHandler.isTargetBlock(level, current = new BlockPos(p.x, startPos.getY(), p.y), target) || !EasyPlantingHandler.isAir(level, current.above()) || targetBlocks.contains(current)) continue;
            targetBlocks.add(current);
            queue.add(new Point(p.x + 1, p.y));
            queue.add(new Point(p.x - 1, p.y));
            queue.add(new Point(p.x, p.y + 1));
            queue.add(new Point(p.x, p.y - 1));
        }
        return targetBlocks;
    }

    private static boolean isWithInCircleDistance(BlockPos start, BlockPos end, int radius) {
        double x = Math.sqrt(Math.pow(start.getX() - end.getX(), 2.0) + Math.pow(start.getZ() - end.getZ(), 2.0));
        return x <= (double)radius + 0.5;
    }

    private static boolean playerHasOneSeed(ServerPlayer player, Item seed) {
        return player.getInventory().hasAnyOf((Set)ImmutableSet.of((Object)seed));
    }

    private static void removeOneSeedFromPlayer(ServerPlayer player, Item seed) {
        if (player.isCreative()) {
            return;
        }
        int slot = player.getInventory().findSlotMatchingItem(new ItemStack((ItemLike)seed));
        if (slot != -1) {
            player.getInventory().removeItem(slot, 1);
        }
    }

    private static boolean isAir(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir();
    }

    private static boolean isTargetBlock(ServerLevel level, BlockPos pos, Block target) {
        return level.getBlockState(pos).is(target);
    }

    private static boolean isSeedItemForCrop(Item item) {
        if (!(item instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)item).getBlock();
        return block instanceof CropBlock || block instanceof StemBlock;
    }
}

