/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public final class MobDropHandler {
    public static void onMobDeath(Level level, LivingEntity entityKilled, DamageSource damageSource) {
        if (!ImprovedVanillaConfig.get().mobDrop().activated()) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        String entityID = Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityKilled.getType())).toString();
        boolean onlyWhenKilledByPlayer = ImprovedVanillaConfig.get().mobDrop().dropOnlyWhenKilledByPlayer();
        double dropChance = ImprovedVanillaConfig.get().mobDrop().dropChance();
        Entity player = damageSource.getEntity();
        BlockPos pos = entityKilled.blockPosition();
        Registry registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (player instanceof ServerPlayer && onlyWhenKilledByPlayer) {
            if (player.isSpectator()) {
                return;
            }
            int lootingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.LOOTING), (LivingEntity)((ServerPlayer)player));
            MobDropHandler.handleKilledByPlayer(level, pos, dropChance, lootingLevel, entityID);
        } else if (!onlyWhenKilledByPlayer) {
            if (player instanceof ServerPlayer) {
                if (player.isSpectator()) {
                    return;
                }
                int lootingLevel = EnchantmentHelper.getEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.LOOTING), (LivingEntity)((ServerPlayer)player));
                MobDropHandler.handleKilledByPlayer(level, pos, dropChance, lootingLevel, entityID);
            } else if (dropChance > 0.0 && dropChance <= 100.0 && Math.random() < dropChance / 100.0) {
                ItemStack stack = ImprovedVanilla.getMonsterEgg(entityID, 1);
                ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
            }
        }
    }

    private static void handleKilledByPlayer(Level level, BlockPos pos, double dropChance, int lootingLevel, String id) {
        boolean lootingAffective = ImprovedVanillaConfig.get().mobDrop().lootingAffective();
        int count = 0;
        if (lootingAffective && lootingLevel >= 1) {
            for (int i = 0; i < 1 + lootingLevel; ++i) {
                if (!(Math.random() < dropChance / 100.0)) continue;
                ++count;
            }
        } else if (Math.random() < dropChance / 100.0) {
            ++count;
        }
        if (count > 0) {
            ItemStack stack = ImprovedVanilla.getMonsterEgg(id, count);
            ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
        }
    }
}

