/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public final class SpawnerHandler {
    public static void onSpawnerBreak(Level level, Player player, BlockPos pos, BlockState state) {
        if (!ImprovedVanillaConfig.get().spawner().activated()) {
            return;
        }
        Block targetBlock = state.getBlock();
        if (level.isClientSide() || targetBlock != Blocks.SPAWNER) {
            return;
        }
        if (!player.getMainHandItem().is(ItemTags.PICKAXES)) {
            return;
        }
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        Registry registry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
        boolean needsSilkTouch = ImprovedVanillaConfig.get().spawner().needsSilkTouch();
        if (!needsSilkTouch || silkTouchLevel >= 1) {
            double eggDropChance;
            double spawnerDropChance = ImprovedVanillaConfig.get().spawner().spawnerDropChance();
            if (spawnerDropChance > 0.0 && spawnerDropChance <= 100.0 && Math.random() < spawnerDropChance / 100.0) {
                ItemStack stack = new ItemStack((ItemLike)Items.SPAWNER, 1);
                ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
            }
            if ((eggDropChance = ImprovedVanillaConfig.get().spawner().spawnEggDropChance()) > 0.0 && eggDropChance <= 100.0 && Math.random() < eggDropChance / 100.0) {
                SpawnerHandler.dropMonsterEggs(level, pos);
            }
        }
    }

    private static void dropMonsterEggs(Level world, BlockPos pos) {
        ItemStack stack = SpawnerHandler.getEggFromSpawner(world, pos);
        ImprovedVanilla.dropItemStackInWorld(world, pos, stack);
    }

    private static ItemStack getEggFromSpawner(Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof SpawnerBlockEntity)) {
            return ItemStack.EMPTY;
        }
        BaseSpawner logic = ((SpawnerBlockEntity)tile).getSpawner();
        TagValueOutput valueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        logic.save((ValueOutput)valueOutput);
        CompoundTag nbt = valueOutput.buildResult();
        if (nbt.contains("SpawnData")) {
            SpawnData spawnData = new SpawnData(nbt.getCompoundOrEmpty("SpawnData").getCompoundOrEmpty("entity"), Optional.empty(), Optional.empty());
            String id = spawnData.entityToSpawn().getStringOr("id", "");
            if (id.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return ImprovedVanilla.getMonsterEgg(id, 1);
        }
        return ItemStack.EMPTY;
    }
}

