/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import com.tristankechlo.improvedvanilla.mixin.CropBlockAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class CropRightClickHandler {
    public static class_1269 onPlayerRightClickBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!ImprovedVanillaConfig.get().cropRightClicking().activated()) {
            return class_1269.field_5811;
        }
        if (player == null || level == null) {
            return class_1269.field_5811;
        }
        if (player.method_5715() || player.method_7325() || hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_6880 heldItem = class_7923.field_41178.method_47983((Object)player.method_6047().method_7909());
        AtomicReference<class_1269.class_9859> result = new AtomicReference<class_1269.class_9859>(class_1269.field_5811);
        if (player.method_6047().method_7960()) {
            if (!level.method_8608()) {
                CropRightClickHandler.spawnDropsAndResetBlock(level, hitResult.method_17777(), 1.0f, () -> result.set((class_1269.class_9859)class_1269.field_5812));
            }
            player.method_23667(hand, true);
        } else if (heldItem.method_40220(class_3489.field_42613)) {
            if (!level.method_8608()) {
                float multiplier = ImprovedVanillaConfig.get().cropRightClicking().modifiers().getOrDefault(heldItem, Float.valueOf(1.0f)).floatValue();
                CropRightClickHandler.spawnDropsAndResetBlock(level, hitResult.method_17777(), multiplier, () -> result.set((class_1269.class_9859)class_1269.field_5812));
            }
            player.method_23667(hand, true);
        }
        return (class_1269)result.get();
    }

    private static void spawnDropsAndResetBlock(class_1937 level, class_2338 pos, float multiplier, Runnable success) {
        class_2248 targetBlock = level.method_8320(pos).method_26204();
        class_2758 ageProperty = CropRightClickHandler.getAgeProperty(targetBlock);
        if (ageProperty == null) {
            return;
        }
        class_2680 blockState = level.method_8320(pos);
        int maximumAge = (Integer)Collections.max(ageProperty.method_11898());
        int currentAge = (Integer)blockState.method_11654((class_2769)ageProperty);
        if (currentAge < maximumAge) {
            return;
        }
        class_2680 newState = (class_2680)blockState.method_11657((class_2769)ageProperty, (Comparable)Integer.valueOf(0));
        level.method_8652(pos, newState, 3);
        List oldLoot = class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)level), (class_2338)pos, null);
        List<class_1799> newLoot = CropRightClickHandler.modifyLoot(oldLoot, multiplier);
        newLoot.forEach(stack -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack));
        success.run();
    }

    private static class_2758 getAgeProperty(class_2248 targetBlock) {
        if (targetBlock instanceof class_2302) {
            return ((CropBlockAccessor)targetBlock).getAgeProperty$improvedVanilla();
        }
        if (targetBlock.equals(class_2246.field_10302)) {
            return class_2282.field_10779;
        }
        if (targetBlock.equals(class_2246.field_9974)) {
            return class_2421.field_11306;
        }
        return null;
    }

    private static List<class_1799> modifyLoot(List<class_1799> loot, float multiplier) {
        boolean blacklistActive = ImprovedVanillaConfig.get().cropRightClicking().removeListEnabled();
        List<class_1856> blacklist = ImprovedVanillaConfig.get().cropRightClicking().removeList();
        HashMap<class_1792, Integer> lootMap = new HashMap<class_1792, Integer>();
        loot.forEach(stack -> {
            if (blacklistActive && blacklist.stream().anyMatch(i -> i.method_8093(stack))) {
                return;
            }
            class_1792 item = stack.method_7909();
            int amount = lootMap.getOrDefault(item, 0);
            lootMap.put(item, amount + stack.method_7947());
        });
        ArrayList<class_1799> newLoot = new ArrayList<class_1799>();
        lootMap.forEach((item, amount) -> {
            int newAmount = Math.round((float)amount.intValue() * multiplier);
            if (newAmount <= 0) {
                return;
            }
            Consumer<class_1799> splitter = CropRightClickHandler.createStackSplitter(newLoot::add);
            splitter.accept(new class_1799((class_1935)item, newAmount));
        });
        return newLoot;
    }

    private static Consumer<class_1799> createStackSplitter(Consumer<class_1799> consumer) {
        return stack -> {
            if (stack.method_7947() < stack.method_7914()) {
                consumer.accept((class_1799)stack);
            } else {
                class_1799 copied;
                for (int count = stack.method_7947(); count > 0; count -= copied.method_7947()) {
                    copied = stack.method_7972();
                    copied.method_7939(Math.min(stack.method_7914(), count));
                    consumer.accept(copied);
                }
            }
        };
    }
}

