/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import com.tristankechlo.improvedvanilla.config.categories.EasyPlantingConfig;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2492;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;

public final class EasyPlantingHandler {
    private static final List<class_1792> VANILLA_SEEDS = ImmutableList.of((Object)class_1802.field_8317, (Object)class_1802.field_8309, (Object)class_1802.field_8179, (Object)class_1802.field_8567);

    public static class_1269 onPlayerRightClickBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!ImprovedVanillaConfig.get().easyPlanting().activated()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        if (player == null || level == null) {
            return class_1269.field_5811;
        }
        if (level.method_8608() || player.method_7325() || hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_2248 targetBlock = level.method_8320(pos).method_26204();
        class_1792 item = player.method_6047().method_7909();
        int radius = ImprovedVanillaConfig.get().easyPlanting().radius();
        if (radius <= 0 || !(item instanceof class_1747)) {
            return class_1269.field_5811;
        }
        if ((VANILLA_SEEDS.contains(item) || EasyPlantingHandler.isSeedItemForCrop(item)) && targetBlock instanceof class_2344) {
            EasyPlantingHandler.setCropsInRadius(radius, pos, class_2246.field_10362, (class_3218)level, (class_3222)player);
            return class_1269.field_5812;
        }
        if (item == class_1802.field_8790 && targetBlock instanceof class_2492) {
            EasyPlantingHandler.setCropsInRadius(radius, pos, class_2246.field_10114, (class_3218)level, (class_3222)player);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void setCropsInRadius(int radius, class_2338 startPos, class_2248 target, class_3218 level, class_3222 player) {
        List<class_2338> targetBlocks = EasyPlantingHandler.getTargetBlocks(radius, level, startPos, target);
        class_1799 mainHandItem = player.method_6047();
        class_1792 seedItem = player.method_6047().method_7909();
        class_2680 blockFromSeed = ((class_1747)seedItem).method_7711().method_9564();
        boolean makeCircle = ImprovedVanillaConfig.get().easyPlanting().placingPattern() == EasyPlantingConfig.PlacingPattern.CIRCLE;
        boolean playPlantingSound = false;
        for (class_2338 pos : targetBlocks) {
            if (makeCircle && !EasyPlantingHandler.isWithInCircleDistance(startPos, pos, radius) || !EasyPlantingHandler.playerHasOneSeed(player, seedItem)) continue;
            level.method_8501(pos.method_10084(), blockFromSeed);
            EasyPlantingHandler.removeOneSeedFromPlayer(player, seedItem);
            player.method_7259(class_3468.field_15372.method_14956((Object)seedItem));
            class_174.field_1191.method_23889(player, pos.method_10084(), mainHandItem);
            playPlantingSound = true;
        }
        if (!playPlantingSound) {
            return;
        }
        if (mainHandItem.method_31574(class_1802.field_8790)) {
            level.method_43128(null, (double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260(), class_3417.field_17613, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            level.method_43128(null, (double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260(), class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private static List<class_2338> getTargetBlocks(int radius, class_3218 level, class_2338 startPos, class_2248 target) {
        ArrayList<class_2338> targetBlocks = new ArrayList<class_2338>();
        LinkedList<Point> queue = new LinkedList<Point>();
        queue.add(new Point(startPos.method_10263(), startPos.method_10260()));
        int minX = startPos.method_10263() - radius;
        int maxX = startPos.method_10263() + radius;
        int minY = startPos.method_10260() - radius;
        int maxY = startPos.method_10260() + radius;
        while (!queue.isEmpty()) {
            class_2338 current;
            Point p = (Point)queue.remove();
            if (p.x < minX || p.x > maxX || p.y < minY || p.y > maxY || !EasyPlantingHandler.isTargetBlock(level, current = new class_2338(p.x, startPos.method_10264(), p.y), target) || !EasyPlantingHandler.isAir(level, current.method_10084()) || targetBlocks.contains(current)) continue;
            targetBlocks.add(current);
            queue.add(new Point(p.x + 1, p.y));
            queue.add(new Point(p.x - 1, p.y));
            queue.add(new Point(p.x, p.y + 1));
            queue.add(new Point(p.x, p.y - 1));
        }
        return targetBlocks;
    }

    private static boolean isWithInCircleDistance(class_2338 start, class_2338 end, int radius) {
        double x = Math.sqrt(Math.pow(start.method_10263() - end.method_10263(), 2.0) + Math.pow(start.method_10260() - end.method_10260(), 2.0));
        return x <= (double)radius + 0.5;
    }

    private static boolean playerHasOneSeed(class_3222 player, class_1792 seed) {
        return player.method_31548().method_18862((Set)ImmutableSet.of((Object)seed));
    }

    private static void removeOneSeedFromPlayer(class_3222 player, class_1792 seed) {
        if (player.method_68878()) {
            return;
        }
        int slot = player.method_31548().method_7395(new class_1799((class_1935)seed));
        if (slot != -1) {
            player.method_31548().method_5434(slot, 1);
        }
    }

    private static boolean isAir(class_3218 level, class_2338 pos) {
        return level.method_8320(pos).method_26215();
    }

    private static boolean isTargetBlock(class_3218 level, class_2338 pos, class_2248 target) {
        return level.method_8320(pos).method_27852(target);
    }

    private static boolean isSeedItemForCrop(class_1792 item) {
        if (!(item instanceof class_1747)) {
            return false;
        }
        class_2248 block = ((class_1747)item).method_7711();
        return block instanceof class_2302 || block instanceof class_2513;
    }
}

