/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class MobDropHandler {
    public static void onMobDeath(class_1937 level, class_1309 entityKilled, class_1282 damageSource) {
        if (!ImprovedVanillaConfig.get().mobDrop().activated()) {
            return;
        }
        if (level.method_8608()) {
            return;
        }
        String entityID = Objects.requireNonNull(class_7923.field_41177.method_10221((Object)entityKilled.method_5864())).toString();
        boolean onlyWhenKilledByPlayer = ImprovedVanillaConfig.get().mobDrop().dropOnlyWhenKilledByPlayer();
        double dropChance = ImprovedVanillaConfig.get().mobDrop().dropChance();
        class_1297 player = damageSource.method_5529();
        class_2338 pos = entityKilled.method_24515();
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41265);
        if (player instanceof class_3222 && onlyWhenKilledByPlayer) {
            if (player.method_7325()) {
                return;
            }
            int lootingLevel = class_1890.method_8203((class_6880)registry.method_46747(class_1893.field_9110), (class_1309)((class_3222)player));
            MobDropHandler.handleKilledByPlayer(level, pos, dropChance, lootingLevel, entityID);
        } else if (!onlyWhenKilledByPlayer) {
            if (player instanceof class_3222) {
                if (player.method_7325()) {
                    return;
                }
                int lootingLevel = class_1890.method_8203((class_6880)registry.method_46747(class_1893.field_9110), (class_1309)((class_3222)player));
                MobDropHandler.handleKilledByPlayer(level, pos, dropChance, lootingLevel, entityID);
            } else if (dropChance > 0.0 && dropChance <= 100.0 && Math.random() < dropChance / 100.0) {
                class_1799 stack = ImprovedVanilla.getMonsterEgg(entityID, 1);
                ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
            }
        }
    }

    private static void handleKilledByPlayer(class_1937 level, class_2338 pos, double dropChance, int lootingLevel, String id) {
        boolean lootingAffective = ImprovedVanillaConfig.get().mobDrop().lootingAffective();
        int count = 0;
        if (lootingAffective && lootingLevel >= 1) {
            for (int i = 0; i < 1 + lootingLevel; ++i) {
                if (!(Math.random() < dropChance / 100.0)) continue;
                ++count;
            }
        } else if (Math.random() < dropChance / 100.0) {
            ++count;
        }
        if (count > 0) {
            class_1799 stack = ImprovedVanilla.getMonsterEgg(id, count);
            ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
        }
    }
}

