/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.improvedvanilla.eventhandler;

import com.tristankechlo.improvedvanilla.ImprovedVanilla;
import com.tristankechlo.improvedvanilla.config.ImprovedVanillaConfig;
import java.util.Optional;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1917;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8942;

public final class SpawnerHandler {
    public static void onSpawnerBreak(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        if (!ImprovedVanillaConfig.get().spawner().activated()) {
            return;
        }
        class_2248 targetBlock = state.method_26204();
        if (level.method_8608() || targetBlock != class_2246.field_10260) {
            return;
        }
        if (!player.method_6047().method_31573(class_3489.field_42614)) {
            return;
        }
        if (player.method_68878() || player.method_7325()) {
            return;
        }
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41265);
        int silkTouchLevel = class_1890.method_8225((class_6880)registry.method_46747(class_1893.field_9099), (class_1799)player.method_6047());
        boolean needsSilkTouch = ImprovedVanillaConfig.get().spawner().needsSilkTouch();
        if (!needsSilkTouch || silkTouchLevel >= 1) {
            double eggDropChance;
            double spawnerDropChance = ImprovedVanillaConfig.get().spawner().spawnerDropChance();
            if (spawnerDropChance > 0.0 && spawnerDropChance <= 100.0 && Math.random() < spawnerDropChance / 100.0) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8849, 1);
                ImprovedVanilla.dropItemStackInWorld(level, pos, stack);
            }
            if ((eggDropChance = ImprovedVanillaConfig.get().spawner().spawnEggDropChance()) > 0.0 && eggDropChance <= 100.0 && Math.random() < eggDropChance / 100.0) {
                SpawnerHandler.dropMonsterEggs(level, pos);
            }
        }
    }

    private static void dropMonsterEggs(class_1937 world, class_2338 pos) {
        class_1799 stack = SpawnerHandler.getEggFromSpawner(world, pos);
        ImprovedVanilla.dropItemStackInWorld(world, pos, stack);
    }

    private static class_1799 getEggFromSpawner(class_1937 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        if (!(tile instanceof class_2636)) {
            return class_1799.field_8037;
        }
        class_1917 logic = ((class_2636)tile).method_11390();
        class_11362 valueOutput = class_11362.method_71458((class_8942)class_8942.field_60348);
        logic.method_8272((class_11372)valueOutput);
        class_2487 nbt = valueOutput.method_71475();
        if (nbt.method_10545("SpawnData")) {
            class_1952 spawnData = new class_1952(nbt.method_68568("SpawnData").method_68568("entity"), Optional.empty(), Optional.empty());
            String id = spawnData.comp_64().method_68564("id", "");
            if (id.isEmpty()) {
                return class_1799.field_8037;
            }
            return ImprovedVanilla.getMonsterEgg(id, 1);
        }
        return class_1799.field_8037;
    }
}

