/*
 * Decompiled with CFR 0.152.
 */
package com.mcwpaths.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EngravedBlock
extends Block {
    public static final BooleanProperty ENGRAVED = BooleanProperty.create((String)"engraved");
    protected static final VoxelShape CUBE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape ENGRAVE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public EngravedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENGRAVED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        boolean engraved = (Boolean)state.getValue((Property)ENGRAVED);
        return engraved ? ENGRAVE : CUBE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENGRAVED});
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        Item item = heldItem.getItem();
        if (item == Items.DIAMOND_PICKAXE || item == Items.GOLDEN_PICKAXE || item == Items.IRON_PICKAXE || item == Items.STONE_PICKAXE || item == Items.WOODEN_PICKAXE || item == Items.NETHERITE_PICKAXE) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            level.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            BlockState newState = (BlockState)state.cycle((Property)ENGRAVED);
            level.setBlock(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

