/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates.block;

import com.falsepattern.lib.mapping.MappingManager;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class Threading_BlockMinMax
implements TurboClassTransformer {
    public static final String classInternal = "net/minecraft/block/Block";
    public static final String packageInternal = "net/minecraft/block/Block".substring(0, "net/minecraft/block/Block".lastIndexOf(47) + 1);
    public static final List<UniversalField> fieldsToRemove = new ArrayList<UniversalField>();
    private static final String targetName = "net/minecraft/block/Block".replace('/', '.');

    static boolean shouldRemoveField(FieldNode fieldNode) {
        return Threading_BlockMinMax.tryMapFieldNodeToMCP(fieldNode) != null;
    }

    static String tryMapFieldNodeToMCP(FieldNode fieldNode) {
        if (fieldNode == null) {
            return null;
        }
        return Threading_BlockMinMax.tryMapFieldNameToMCP(fieldNode.name);
    }

    static String tryMapFieldNameToMCP(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (UniversalField field : fieldsToRemove) {
            String mcpName = field.getName(MappingType.MCP);
            if (fieldName.equals(mcpName)) {
                return mcpName;
            }
            if (fieldName.equals(field.getName(MappingType.Notch))) {
                return mcpName;
            }
            if (!fieldName.equals(field.getName(MappingType.SRG))) continue;
            return mcpName;
        }
        return null;
    }

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_BlockMinMax";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return targetName.equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        Iterator iter = cn.fields.iterator();
        boolean changed = false;
        while (iter.hasNext()) {
            FieldNode field = (FieldNode)iter.next();
            if (!Threading_BlockMinMax.shouldRemoveField(field)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    static {
        try {
            UniversalClass blockClass = MappingManager.classForName((NameType)NameType.Internal, (MappingType)MappingType.MCP, (String)classInternal);
            List<String> mcpFields = Arrays.asList("minX", "minY", "minZ", "maxX", "maxY", "maxZ");
            for (String mcpField : mcpFields) {
                fieldsToRemove.add(blockClass.getField(MappingType.MCP, mcpField));
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

