/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates.compat;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Threading_AngelicaCompatFixer
implements TurboClassTransformer {
    private static final String OPTIONAL_INTERFACE_ANN_DESC = "Lcpw/mods/fml/common/Optional$Interface;";
    private static final String OPTIONAL_METHOD_ANN_DESC = "Lcpw/mods/fml/common/Optional$Method;";
    private static final String ANGELICA_THREAD_SAFE_FACTORY_InternalName = "com/gtnewhorizons/angelica/api/ThreadSafeISBRHFactory";
    private static final String ANGELICA_THREAD_SAFE_FACTORY_ClassName = "com/gtnewhorizons/angelica/api/ThreadSafeISBRHFactory".replace('/', '.');
    private static final String ANGELICA_FACTORY_METHOD_DESC = "()Lcom/gtnewhorizons/angelica/api/ThreadSafeISBRHFactory;";
    private static final String THREAD_SAFE_FACTORY_ClassName = "com/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRHFactory".replace('/', '.');

    @NotNull
    private static ArrayList<Object> constructNewValues(String modid, Boolean stripRefs) {
        ArrayList<Object> newValues = new ArrayList<Object>();
        newValues.add("iface");
        newValues.add(THREAD_SAFE_FACTORY_ClassName);
        newValues.add("modid");
        if ("angelica".equals(modid)) {
            newValues.add("falsetweaks");
        } else {
            newValues.add(modid);
        }
        if (stripRefs != null) {
            newValues.add("striprefs");
            newValues.add(stripRefs);
        }
        return newValues;
    }

    public String owner() {
        return "falsetweaks";
    }

    public String name() {
        return "Threading_AngelicaCompatFixer";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return true;
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        Object value;
        String name;
        Iterator iter;
        List values;
        ClassNode node = classNode.getNode();
        if (node == null) {
            return false;
        }
        boolean found = false;
        List anns = node.visibleAnnotations;
        if (anns == null) {
            return false;
        }
        for (AnnotationNode ann : anns) {
            if (!ann.desc.equals(OPTIONAL_INTERFACE_ANN_DESC)) continue;
            boolean isFactory = false;
            String modid = null;
            Boolean stripRefs = null;
            values = ann.values;
            if (values == null) continue;
            iter = values.iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                value = iter.next();
                switch (name) {
                    case "iface": {
                        if (!ANGELICA_THREAD_SAFE_FACTORY_ClassName.equals(value)) break;
                        isFactory = true;
                        break;
                    }
                    case "modid": {
                        modid = (String)value;
                        break;
                    }
                    case "striprefs": {
                        stripRefs = (Boolean)value;
                    }
                }
            }
            if (!isFactory) continue;
            found = true;
            ann.values = Threading_AngelicaCompatFixer.constructNewValues(modid, stripRefs);
            break;
        }
        if (!found) {
            return false;
        }
        for (MethodNode method : node.methods) {
            List anns2;
            if (!"newInstance".equals(method.name) || !"()Lcom/falsepattern/falsetweaks/modules/threadedupdates/interop/ThreadSafeISBRHFactory;".equals(method.desc) || (anns2 = method.visibleAnnotations) == null) continue;
            for (AnnotationNode ann : anns2) {
                if (!ann.desc.equals(OPTIONAL_METHOD_ANN_DESC)) continue;
                String modid = null;
                values = ann.values;
                if (values == null) continue;
                iter = values.iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    value = iter.next();
                    if (!"modid".equals(name)) continue;
                    modid = (String)value;
                    break;
                }
                if (!"angelica".equals(modid)) continue;
                ann.values = new ArrayList<String>(Arrays.asList("modid", "falsetweaks"));
            }
        }
        return true;
    }
}

