/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates.settings;

import com.falsepattern.lib.mapping.MappingManager;
import com.falsepattern.lib.mapping.types.MappingType;
import com.falsepattern.lib.mapping.types.NameType;
import com.falsepattern.lib.mapping.types.UniversalClass;
import com.falsepattern.lib.mapping.types.UniversalField;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.Iterator;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;

public final class Threading_GameSettings
implements TurboClassTransformer {
    static final UniversalClass GAME_SETTINGS_CLASS;
    static final UniversalField FANCY_GRAPHICS_FIELD;

    static boolean isTargetOwner(FieldInsnNode fieldInst) {
        if (fieldInst == null) {
            return false;
        }
        String owner = fieldInst.owner;
        if (owner == null) {
            return false;
        }
        if (owner.equals(GAME_SETTINGS_CLASS.getName(NameType.Internal, MappingType.Notch))) {
            return true;
        }
        if (owner.equals(GAME_SETTINGS_CLASS.getName(NameType.Internal, MappingType.SRG))) {
            return true;
        }
        return owner.equals(GAME_SETTINGS_CLASS.getName(NameType.Internal, MappingType.MCP));
    }

    static boolean shouldRemoveField(FieldNode fieldNode) {
        return Threading_GameSettings.tryMapFieldNodeToMCP(fieldNode) != null;
    }

    static String tryMapFieldNodeToMCP(FieldNode fieldNode) {
        if (fieldNode == null) {
            return null;
        }
        return Threading_GameSettings.tryMapFieldNameToMCP(fieldNode.name);
    }

    static String tryMapFieldNameToMCP(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String mcpName = FANCY_GRAPHICS_FIELD.getName(MappingType.MCP);
        if (fieldName.equals(mcpName)) {
            return mcpName;
        }
        if (fieldName.equals(FANCY_GRAPHICS_FIELD.getName(MappingType.Notch))) {
            return mcpName;
        }
        if (fieldName.equals(FANCY_GRAPHICS_FIELD.getName(MappingType.SRG))) {
            return mcpName;
        }
        return null;
    }

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_GameSettings";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return Threading_GameSettings.GAME_SETTINGS_CLASS.regularName.srg.equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        Iterator iter = cn.fields.iterator();
        boolean changed = false;
        while (iter.hasNext()) {
            FieldNode field = (FieldNode)iter.next();
            if (!Threading_GameSettings.shouldRemoveField(field)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Generated
    public Threading_GameSettings() {
    }

    static {
        try {
            GAME_SETTINGS_CLASS = MappingManager.classForName((NameType)NameType.Regular, (MappingType)MappingType.MCP, (String)"net.minecraft.client.settings.GameSettings");
            FANCY_GRAPHICS_FIELD = GAME_SETTINGS_CLASS.getField(MappingType.MCP, "fancyGraphics");
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new AssertionError("Woe be upon ye traveler!", e);
        }
    }
}

