/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.config;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.config.AOFixConfig;
import com.falsepattern.falsetweaks.config.CrackFixConfig;
import com.falsepattern.falsetweaks.config.DynamicLightsConfig;
import com.falsepattern.falsetweaks.config.OptiSpamConfig;
import com.falsepattern.falsetweaks.config.ProfilerConfig;
import com.falsepattern.falsetweaks.config.RenderDistanceConfig;
import com.falsepattern.falsetweaks.config.RenderListConfig;
import com.falsepattern.falsetweaks.config.RenderingSafetyConfig;
import com.falsepattern.falsetweaks.config.ThreadingConfig;
import com.falsepattern.falsetweaks.config.TranslucentBlockLayersConfig;
import com.falsepattern.falsetweaks.config.TriangulatorConfig;
import com.falsepattern.falsetweaks.config.VoxelizerConfig;
import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;

@Config.Comment(value={"Toggles for all FalseTweaks modules"})
@Config(modid="falsetweaks", category="00_modules")
@Config.LangKey
public class ModuleConfig {
    @Config.Comment(value={"Optimizes the way forge scans the classpath during launch.", "Not compatible with some badly-written mods.", "FPS impact: None, but makes startup a bit faster"})
    @Config.LangKey
    @Config.Name(value="startupOptimizations")
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean STARTUP_OPTIMIZATIONS;
    @Config.Comment(value={"Enable/Disable texture optimizations. This includes:", "- Multithreaded animated textures", "- Faster texture atlas packing during startup", "FPS impact: Reduced stuttering in heavily modded packs"})
    @Config.LangKey
    @Config.Name(value="textureOptimizations", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean TEXTURE_OPTIMIZATIONS;
    @Config.Comment(value={"Enable/Disable item voxelization. This fixes a huge amount of item render issues, but is still", "an experimental feature.", "Also includes the 3D rails."})
    @Config.LangKey(value="config.falsetweaks.voxelizer")
    @Config.Name(value="voxelizer", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean VOXELIZER;
    @Config.Comment(value={"Enables the Triangulator module, which fixes the smooth lighting along block diagonals.", "FPS impact: Minimal."})
    @Config.LangKey(value="config.falsetweaks.triangulator")
    @Config.Name(value="triangulator", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean TRIANGULATOR;
    @Config.Comment(value={"Enable an optimized, BSP-tree based vertex sorting algorithm for transparent blocks.", "FPS impact: A little bit less stuttering when moving around with a lot of stained glass-like blocks around"})
    @Config.LangKey
    @Config.Name(value="bspSorting", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean BSP_SORTING;
    @Config.Comment(value={"Dropped and held items are re-rendered every frame, generating a lot of", "unnecessary CPU load because of the very inefficient way the rendering is done.", "With this enabled, FalseTweaks will cache pre-rendered versions of items into RenderLists", "(same things that chunks use) to minimize the amount of work done by the cpu for every single item.", "FPS impact: Decent improvement with lots of items on ground"})
    @Config.LangKey(value="config.falsetweaks.item_render_lists")
    @Config.Name(value="itemRenderLists", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean ITEM_RENDER_LISTS;
    @Config.Comment(value={"Disables the Realms button on the main menu."})
    @Config.LangKey
    @Config.Name(value="noRealmsOnMenu", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean NO_REALMS_ON_MENU;
    @Config.Comment(value={"Beacons also have an optimization using renderlists. If you spot any issues related to beacons,", "you can toggle said optimization here.", "FPS impact: Tiny improvement near beacons"})
    @Config.LangKey
    @Config.Name(value="beaconOptimization", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean BEACON_OPTIMIZATION;
    @Config.Comment(value={"Transparent tile entities (beacons, for instance) might render behind other tile entities that are", "actually BEHIND the transparent part. Sorting the tile entities before rendering fixes this bug.", "FPS impact: Slight decrease"})
    @Config.LangKey
    @Config.Name(value="tileEntityTransparencyFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean TE_TRANSPARENCY_FIX;
    @Config.Comment(value={"Makes translucent geometry of chunks render slightly closer to the camera. (experimental)", "This reduces Z-Fighting on blocks which have overlapping opaque and translucent geometry,", "at the cost of far away geometry sometimes rendering on top of opaque geometry. (>100~ blocks)", "Don't turn this on unless you absolutely need it.", "FPS impact: Unknown"})
    @Config.LangKey(value="config.falsetweaks.translucent_block_layers_fix")
    @Config.Name(value="translucentBlockLayersFix", migrations={""})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean BLOCK_LAYER_TRANSPARENCY_FIX;
    @Config.Comment(value={"Fixes layering issues with particles always rendering behind water."})
    @Config.LangKey
    @Config.Name(value="particleTransparencyFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean PARTICLE_TRANSPARENCY_FIX;
    @Config.Comment(value={"3D block breaking particles"})
    @Config.LangKey
    @Config.Name(value="cubicParticles", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean CUBIC_PARTICLES;
    @Config.Comment(value={"Replaces the mipmap generation with a multithreaded system, which scales with the number of cores in your system.", "FPS impact: none, but resource pack reload times (and startup time) are cut down by a lot"})
    @Config.LangKey
    @Config.Name(value="mipmapFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean MIPMAP_FIX;
    @Config.Comment(value={"Replaces the minecraft profiler with fully custom logic (used in the Shift+F3 pie chart)", "Also check the profiler config category!", "FPS impact: Slightly faster profiler"})
    @Config.LangKey(value="config.falsetweaks.profiler")
    @Config.Name(value="advancedProfiler", migrations={""})
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean ADVANCED_PROFILER;
    @Config.Comment(value={"Enables multi-threaded chunk updating.", "Requires Beddium installed.", "FPS impact: Significant FPS and world rendering speed gains with Beddium."})
    @Config.LangKey(value="config.falsetweaks.threading")
    @Config.Name(value="threadedChunkUpdates", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean THREADED_CHUNK_UPDATES;
    @Config.Comment(value={"OptiFine-style dynamic lights, but works without OptiFine", "Force-enables CHUNK_CACHE.", "Implicitly enabled when OptiFine is installed for compatibility.", "See the dynamiclights config entry for more configs."})
    @Config.LangKey(value="config.falsetweaks.dynamic_lights")
    @Config.Name(value="dynamicLights", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean DYNAMIC_LIGHTS;
    @Config.Comment(value={"Replaces the renderer chunk cache with a more efficient version.", "FPS impact: Faster chunk rendering"})
    @Config.LangKey
    @Config.Name(value="fasterChunkCache", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean FASTER_CHUNK_CACHE;
    @Config.Comment(value={"Wraps block renderer code and tile entity renderer code in extra opengl state guards."})
    @Config.LangKey
    @Config.Name(value="renderingSafety", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean RENDERING_SAFETY;
    @Config.Comment(value={"Gets rid of that obnoxious burst of minecart sounds when joining a world."})
    @Config.LangKey
    @Config.Name(value="minecartEarBlastFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean MINECART_EAR_BLAST_FIX;
    @Config.Comment(value={"Improves the performance of the minecraft sky mesh.", "Also fixes the weird white lines that some OptiFine shaderpacks get with huge render distances.", "FPS impact: Negligible gain"})
    @Config.LangKey
    @Config.Name(value="skyMeshOptimization", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean SKY_MESH_OPTIMIZATION;
    @Config.Comment(value={"Fixes an occasional crash that happens when trying to render a GUI block overlay (more common with optifine shaders enabled.)", "FPS impact: Zero"})
    @Config.LangKey
    @Config.Name(value="overlayCrashFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean OVERLAY_CRASH_FIX;
    @Config.Comment(value={"Suppresses logspam coming from optifine's shader system. Makes shaderpack reloads faster."})
    @Config.LangKey(value="config.falsetweaks.optifine_log_spam_fixes")
    @Config.Name(value="optifineLogSpamFixes", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean OPTIFINE_LOGSPAM_FIX;
    @Config.Comment(value={"Reduces the amount of opengl reads the game does for calculating frustum clipping matrixes.", "Might break with some mods."})
    @Config.LangKey
    @Config.Name(value="clippingHelperOncePerFrame")
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean CLIPPING_HELPER_ONCE_PER_FRAME;
    @Config.Comment(value={"Optimizes the math used when calculating frustum clipping matrixes."})
    @Config.LangKey
    @Config.Name(value="clippingHelperOpts")
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean CLIPPING_HELPER_OPTS;
    @Config.Comment(value={"Unlocks the render distance to above 16. See the \"camera\" category for more options.", "Incompatible with ArchaicFix raiseMaxRenderDistance"})
    @Config.LangKey
    @Config.Name(value="unlockRenderDistance")
    @Config.DefaultBoolean(value=false)
    @Config.RequiresMcRestart
    public static boolean UNLOCK_RENDER_DISTANCE;
    @Config.Comment(value={"Slightly improves item entity rendering performance. Disable if you get any texture weirdness!", "Fast - Standard performance improvements", "Faster - More aggressive performance improvements, some dropped items might look odd"})
    @Config.LangKey
    @Config.Name(value="fastItemEntityTextureSwitching")
    @Config.DefaultEnum(value="Faster")
    @Config.RequiresMcRestart
    public static ItemTexturing FAST_ITEM_ENTITY_TEXTURE_SWITCHING;
    @Config.Comment(value={"Improves the performance of items significantly by not checking collisions against other entities for them.", "(10x fps improvements with a lot of dropped items)", "Also works serverside, improving tick times."})
    @Config.LangKey
    @Config.Name(value="fastItemPhysics")
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean FAST_ITEM_ENTITY_PHYSICS;
    @Config.Comment(value={"Block corners and edges between chunks might have \"cracks\" in them. This option fixes it.", "FPS impact: None"})
    @Config.LangKey(value="config.falsetweaks.crack_fix")
    @Config.Name(value="blockCrackFix", migrations={""})
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean blockCrackFix;
    @Config.Comment(value={"Improves ambient occlusion and smooth lighting on blocks.", "FPS impact: None"})
    @Config.LangKey(value="config.falsetweaks.ao_fix")
    @Config.DefaultBoolean(value=true)
    @Config.RequiresMcRestart
    public static boolean aoFix;

    public static boolean THREADED_CHUNK_UPDATES() {
        return Compat.beddiumInstalled() && THREADED_CHUNK_UPDATES;
    }

    public static void init() {
    }

    static {
        ConfigurationManager.selfInit();
        ProfilerConfig.init();
        RenderListConfig.init();
        TriangulatorConfig.init();
        VoxelizerConfig.init();
        TranslucentBlockLayersConfig.init();
        RenderDistanceConfig.init();
        ThreadingConfig.init();
        DynamicLightsConfig.init();
        RenderingSafetyConfig.init();
        OptiSpamConfig.init();
        CrackFixConfig.init();
        AOFixConfig.init();
    }

    public static enum ItemTexturing {
        Disabled,
        Fast,
        Faster;

    }
}

