/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.mixin.mixins.common.startup;

import com.falsepattern.falsetweaks.modules.startup.ThreadSafeASMDataTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ASMDataTable.class}, remap=false)
public abstract class ASMDataTableMixin
implements ThreadSafeASMDataTable {
    @Shadow
    private Map<ModContainer, SetMultimap<String, ASMDataTable.ASMData>> containerAnnotationData;
    @Shadow
    private List<ModContainer> containers;
    @Shadow
    private SetMultimap<String, ASMDataTable.ASMData> globalAnnotationData;
    @Shadow
    private SetMultimap<String, ModCandidate> packageMap;
    private ReentrantLock mutex = null;

    @Override
    public void enableMutex(boolean enable) {
        this.mutex = enable ? new ReentrantLock() : null;
    }

    private void lock() {
        if (this.mutex != null) {
            this.mutex.lock();
        }
    }

    private void unlock() {
        if (this.mutex != null) {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public SetMultimap<String, ASMDataTable.ASMData> getAnnotationsFor(ModContainer container) {
        this.lock();
        try {
            if (this.containerAnnotationData == null) {
                HashMap<ModContainer, SetMultimap<String, ASMDataTable.ASMData>> mapBuilder = new HashMap<ModContainer, SetMultimap<String, ASMDataTable.ASMData>>();
                ImmutableListMultimap containersMap = Multimaps.index(this.containers, ModContainer::getSource);
                for (Map.Entry entry : this.globalAnnotationData.entries()) {
                    for (ModContainer modContainer : containersMap.get((Object)((ASMDataTable.ASMData)entry.getValue()).getCandidate().getModContainer())) {
                        mapBuilder.computeIfAbsent(modContainer, map -> HashMultimap.create()).put(entry.getKey(), entry.getValue());
                    }
                }
                this.containerAnnotationData = mapBuilder;
            }
            SetMultimap<String, ASMDataTable.ASMData> setMultimap = this.containerAnnotationData.get(container);
            return setMultimap;
        }
        finally {
            this.unlock();
        }
    }

    @Overwrite(remap=false)
    public Set<ASMDataTable.ASMData> getAll(String annotation) {
        this.lock();
        try {
            Set set = this.globalAnnotationData.get((Object)annotation);
            return set;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public void addASMData(ModCandidate candidate, String annotation, String className, String objectName, Map<String, Object> annotationInfo) {
        this.lock();
        try {
            this.globalAnnotationData.put((Object)annotation, (Object)new ASMDataTable.ASMData(candidate, annotation, className, objectName, annotationInfo));
        }
        finally {
            this.unlock();
        }
    }

    @Overwrite(remap=false)
    public void addContainer(ModContainer container) {
        this.lock();
        try {
            this.containers.add(container);
        }
        finally {
            this.unlock();
        }
    }

    @Overwrite(remap=false)
    public void registerPackage(ModCandidate modCandidate, String pkg) {
        this.lock();
        try {
            this.packageMap.put((Object)pkg, (Object)modCandidate);
        }
        finally {
            this.unlock();
        }
    }

    @Overwrite(remap=false)
    public Set<ModCandidate> getCandidatesFor(String pkg) {
        this.lock();
        try {
            Set set = this.packageMap.get((Object)pkg);
            return set;
        }
        finally {
            this.unlock();
        }
    }
}

