/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.ao;

import com.falsepattern.falsetweaks.Compat;
import com.falsepattern.falsetweaks.modules.ao.AOMath;
import com.falsepattern.falsetweaks.modules.ao.AORenderer;
import com.falsepattern.falsetweaks.modules.ao.BrightnessMath;
import com.falsepattern.falsetweaks.modules.triangulator.renderblocks.Facing;
import com.falsepattern.lib.util.MathUtil;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import org.joml.Vector3ic;

public class AmbientOcclusionRenderer
implements AORenderer {
    private static final Facing.Direction[] dirs = Facing.Direction.values();
    private final float[] ao = new float[27];
    private final int[] light = new int[27];
    private final float[] inset = new float[dirs.length];
    private float r;
    private float g;
    private float b;
    private float aoTopLeft;
    private float aoTopRight;
    private float aoBottomLeft;
    private float aoBottomRight;
    private int brightnessTopLeft;
    private int brightnessTopRight;
    private int brightnessBottomLeft;
    private int brightnessBottomRight;

    @Override
    public boolean renderWithAO(RenderBlocks rb, Block block, int x, int y, int z, float r, float g, float b) {
        rb.field_147863_w = true;
        Compat.tessellator().func_78380_c(0xF000F0);
        this.fetchLightingData(rb, block, x, y, z);
        boolean useColor = !rb.func_147745_b(block).func_94215_i().equals("grass_top") && !rb.func_147744_b();
        this.r = r;
        this.g = g;
        this.b = b;
        boolean drewSomething = this.renderFace(rb, Facing.YNEG, block, x, y, z, useColor);
        drewSomething |= this.renderFace(rb, Facing.YPOS, block, x, y, z, useColor);
        drewSomething |= this.renderFace(rb, Facing.ZNEG, block, x, y, z, useColor);
        drewSomething |= this.renderFace(rb, Facing.ZPOS, block, x, y, z, useColor);
        drewSomething |= this.renderFace(rb, Facing.XNEG, block, x, y, z, useColor);
        rb.field_147863_w = false;
        return drewSomething |= this.renderFace(rb, Facing.XPOS, block, x, y, z, useColor);
    }

    private boolean renderFace(RenderBlocks rb, Facing facing, Block block, int x, int y, int z, boolean useColor) {
        if (!rb.field_147837_f && !this.shouldSideBeRenderedQuick(rb, block, x, y, z, facing)) {
            return false;
        }
        float inset = MathUtil.clamp((float)(this.getInset(facing.face) * 2.0f), (float)0.0f, (float)1.0f);
        boolean isInset = inset != 0.0f;
        this.fetchMixedAO(facing, true);
        if (isInset) {
            float aoTopLeftOut = this.aoTopLeft;
            float aoTopRightOut = this.aoTopRight;
            float aoBottomLeftOut = this.aoBottomLeft;
            float aoBottomRightOut = this.aoBottomRight;
            int brightnessTopLeftOut = this.brightnessTopLeft;
            int brightnessTopRightOut = this.brightnessTopRight;
            int brightnessBottomLeftOut = this.brightnessBottomLeft;
            int brightnessBottomRightOut = this.brightnessBottomRight;
            this.fetchMixedAO(facing, false);
            this.aoTopLeft = AOMath.lerpAO(aoTopLeftOut, this.aoTopLeft, inset);
            this.aoTopRight = AOMath.lerpAO(aoTopRightOut, this.aoTopRight, inset);
            this.aoBottomLeft = AOMath.lerpAO(aoBottomLeftOut, this.aoBottomLeft, inset);
            this.aoBottomRight = AOMath.lerpAO(aoBottomRightOut, this.aoBottomRight, inset);
            this.brightnessTopLeft = BrightnessMath.lerpBrightness(brightnessTopLeftOut, this.brightnessTopLeft, inset);
            this.brightnessTopRight = BrightnessMath.lerpBrightness(brightnessTopRightOut, this.brightnessTopRight, inset);
            this.brightnessBottomLeft = BrightnessMath.lerpBrightness(brightnessBottomLeftOut, this.brightnessBottomLeft, inset);
            this.brightnessBottomRight = BrightnessMath.lerpBrightness(brightnessBottomRightOut, this.brightnessBottomRight, inset);
        }
        this.dispatchRender(rb, facing, block, x, y, z, useColor);
        return true;
    }

    private void fetchMixedAO(Facing facing, boolean front) {
        int brightnessBottomLeft;
        float lightBottomLeft;
        int brightnessBottomRight;
        float lightBottomRight;
        int brightnessTopRight;
        float lightTopRight;
        int brightnessTopLeft;
        float lightTopLeft;
        boolean transparentTop;
        int z;
        int y;
        int x;
        if (front) {
            x = 1 + facing.front.x();
            y = 1 + facing.front.y();
            z = 1 + facing.front.z();
        } else {
            x = 1;
            y = 1;
            z = 1;
        }
        float aoCenter = this.getAO(x, y, z);
        float aoLeft = this.getAO(x, y, z, facing.left);
        float aoRight = this.getAO(x, y, z, facing.right);
        float aoBottom = this.getAO(x, y, z, facing.bottom);
        float aoTop = this.getAO(x, y, z, facing.top);
        int brightnessCenter = this.getBrightness(x, y, z);
        int brightnessLeft = this.getBrightness(x, y, z, facing.left);
        int brightnessRight = this.getBrightness(x, y, z, facing.right);
        int brightnessBottom = this.getBrightness(x, y, z, facing.bottom);
        int brightnessTop = this.getBrightness(x, y, z, facing.top);
        boolean transparentLeft = aoLeft == 1.0f;
        boolean transparentRight = aoRight == 1.0f;
        boolean transparentBottom = aoBottom == 1.0f;
        boolean bl = transparentTop = aoTop == 1.0f;
        if (!transparentLeft && !transparentTop) {
            lightTopLeft = AOMath.averageAO(aoLeft, aoTop);
            brightnessTopLeft = BrightnessMath.averageBrightness(brightnessLeft, brightnessTop);
        } else {
            lightTopLeft = this.getAO(x, y, z, facing.topLeft);
            brightnessTopLeft = this.getBrightness(x, y, z, facing.topLeft);
        }
        if (!transparentRight && !transparentTop) {
            lightTopRight = AOMath.averageAO(aoRight, aoTop);
            brightnessTopRight = BrightnessMath.averageBrightness(brightnessRight, brightnessTop);
        } else {
            lightTopRight = this.getAO(x, y, z, facing.topRight);
            brightnessTopRight = this.getBrightness(x, y, z, facing.topRight);
        }
        if (!transparentRight && !transparentBottom) {
            lightBottomRight = AOMath.averageAO(aoRight, aoBottom);
            brightnessBottomRight = BrightnessMath.averageBrightness(brightnessRight, brightnessBottom);
        } else {
            lightBottomRight = this.getAO(x, y, z, facing.bottomRight);
            brightnessBottomRight = this.getBrightness(x, y, z, facing.bottomRight);
        }
        if (!transparentLeft && !transparentBottom) {
            lightBottomLeft = AOMath.averageAO(aoLeft, aoBottom);
            brightnessBottomLeft = BrightnessMath.averageBrightness(brightnessLeft, brightnessBottom);
        } else {
            lightBottomLeft = this.getAO(x, y, z, facing.bottomLeft);
            brightnessBottomLeft = this.getBrightness(x, y, z, facing.bottomLeft);
        }
        float aoTopLeftRaw = AOMath.averageAO(aoLeft, lightTopLeft, aoCenter, aoTop);
        float aoTopRightRaw = AOMath.averageAO(aoCenter, aoTop, aoRight, lightTopRight);
        float aoBottomRightRaw = AOMath.averageAO(aoBottom, aoCenter, lightBottomRight, aoRight);
        float aoBottomLeftRaw = AOMath.averageAO(lightBottomLeft, aoLeft, aoBottom, aoCenter);
        int brightnessTopLeftRaw = BrightnessMath.averageBrightness(brightnessLeft, brightnessTopLeft, brightnessTop, brightnessCenter);
        int brightnessBottomLeftRaw = BrightnessMath.averageBrightness(brightnessBottomLeft, brightnessLeft, brightnessBottom, brightnessCenter);
        int brightnessBottomRightRaw = BrightnessMath.averageBrightness(brightnessBottom, brightnessBottomRight, brightnessRight, brightnessCenter);
        int brightnessTopRightRaw = BrightnessMath.averageBrightness(brightnessTop, brightnessRight, brightnessTopRight, brightnessCenter);
        float insetLeft = this.getInset(facing.leftFace);
        float insetRight = this.getInset(facing.rightFace);
        float insetTop = this.getInset(facing.topFace);
        float insetBottom = this.getInset(facing.bottomFace);
        this.aoTopLeft = AOMath.biLerpAO(aoTopLeftRaw, aoTopRightRaw, aoBottomLeftRaw, aoBottomRightRaw, insetLeft, insetTop);
        this.aoTopRight = AOMath.biLerpAO(aoTopRightRaw, aoTopLeftRaw, aoBottomRightRaw, aoBottomLeftRaw, insetRight, insetTop);
        this.aoBottomLeft = AOMath.biLerpAO(aoBottomLeftRaw, aoBottomRightRaw, aoTopLeftRaw, aoTopRightRaw, insetLeft, insetBottom);
        this.aoBottomRight = AOMath.biLerpAO(aoBottomRightRaw, aoBottomLeftRaw, aoTopRightRaw, aoTopLeftRaw, insetRight, insetBottom);
        this.brightnessTopLeft = BrightnessMath.biLerpBrightness(brightnessTopLeftRaw, brightnessTopRightRaw, brightnessBottomLeftRaw, brightnessBottomRightRaw, insetLeft, insetTop);
        this.brightnessTopRight = BrightnessMath.biLerpBrightness(brightnessTopRightRaw, brightnessTopLeftRaw, brightnessBottomRightRaw, brightnessBottomLeftRaw, insetRight, insetTop);
        this.brightnessBottomLeft = BrightnessMath.biLerpBrightness(brightnessBottomLeftRaw, brightnessBottomRightRaw, brightnessTopLeftRaw, brightnessTopRightRaw, insetLeft, insetBottom);
        this.brightnessBottomRight = BrightnessMath.biLerpBrightness(brightnessBottomRightRaw, brightnessBottomLeftRaw, brightnessTopRightRaw, brightnessTopLeftRaw, insetRight, insetBottom);
    }

    private float getInset(Facing.Direction dir) {
        return this.inset[dir.ordinal()];
    }

    private void dispatchRender(RenderBlocks rb, Facing facing, Block block, int x, int y, int z, boolean useColor) {
        rb.field_147864_al = this.brightnessTopLeft;
        rb.field_147874_am = this.brightnessBottomLeft;
        rb.field_147876_an = this.brightnessBottomRight;
        rb.field_147870_ao = this.brightnessTopRight;
        if (useColor || facing.face == Facing.Direction.FACE_YPOS) {
            rb.field_147850_ar = rb.field_147848_as = this.r * facing.brightness;
            rb.field_147852_aq = rb.field_147848_as;
            rb.field_147872_ap = rb.field_147848_as;
            rb.field_147858_av = rb.field_147856_aw = this.g * facing.brightness;
            rb.field_147860_au = rb.field_147856_aw;
            rb.field_147846_at = rb.field_147856_aw;
            rb.field_147839_az = rb.field_147833_aA = this.b * facing.brightness;
            rb.field_147841_ay = rb.field_147833_aA;
            rb.field_147854_ax = rb.field_147833_aA;
        } else {
            rb.field_147850_ar = rb.field_147848_as = facing.brightness;
            rb.field_147852_aq = rb.field_147848_as;
            rb.field_147872_ap = rb.field_147848_as;
            rb.field_147858_av = rb.field_147856_aw = facing.brightness;
            rb.field_147860_au = rb.field_147856_aw;
            rb.field_147846_at = rb.field_147856_aw;
            rb.field_147839_az = rb.field_147833_aA = facing.brightness;
            rb.field_147841_ay = rb.field_147833_aA;
            rb.field_147854_ax = rb.field_147833_aA;
        }
        rb.field_147872_ap *= this.aoTopLeft;
        rb.field_147846_at *= this.aoTopLeft;
        rb.field_147854_ax *= this.aoTopLeft;
        rb.field_147852_aq *= this.aoBottomLeft;
        rb.field_147860_au *= this.aoBottomLeft;
        rb.field_147841_ay *= this.aoBottomLeft;
        rb.field_147850_ar *= this.aoBottomRight;
        rb.field_147858_av *= this.aoBottomRight;
        rb.field_147839_az *= this.aoBottomRight;
        rb.field_147848_as *= this.aoTopRight;
        rb.field_147856_aw *= this.aoTopRight;
        rb.field_147833_aA *= this.aoTopRight;
        IIcon icon = rb.func_147793_a(block, rb.field_147845_a, x, y, z, facing.face.ordinal());
        this.doRenderFace(rb, block, x, y, z, facing, icon);
        if (facing.face != Facing.Direction.FACE_YNEG && facing.face != Facing.Direction.FACE_YPOS && RenderBlocks.field_147843_b && icon.func_94215_i().equals("grass_side") && !rb.func_147744_b()) {
            float r = this.r;
            float g = this.g;
            float b = this.b;
            rb.field_147872_ap *= r;
            rb.field_147852_aq *= r;
            rb.field_147850_ar *= r;
            rb.field_147848_as *= r;
            rb.field_147846_at *= g;
            rb.field_147860_au *= g;
            rb.field_147858_av *= g;
            rb.field_147856_aw *= g;
            rb.field_147854_ax *= b;
            rb.field_147841_ay *= b;
            rb.field_147839_az *= b;
            rb.field_147833_aA *= b;
            IIcon sideIcon = BlockGrass.func_149990_e();
            this.doRenderFace(rb, block, x, y, z, facing, sideIcon);
        }
    }

    private void doRenderFace(RenderBlocks rb, Block block, int x, int y, int z, Facing facing, IIcon icon) {
        switch (facing) {
            case YNEG: {
                rb.func_147768_a(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case YPOS: {
                rb.func_147806_b(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case ZNEG: {
                rb.func_147761_c(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case ZPOS: {
                rb.func_147734_d(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case XNEG: {
                rb.func_147798_e(block, (double)x, (double)y, (double)z, icon);
                break;
            }
            case XPOS: {
                rb.func_147764_f(block, (double)x, (double)y, (double)z, icon);
            }
        }
    }

    private float getAO(int x, int y, int z, Vector3ic offset) {
        return this.getAO(x += offset.x(), y += offset.y(), z += offset.z());
    }

    private float getAO(int x, int y, int z) {
        int index = this.toIndex(x, y, z);
        return this.ao[index];
    }

    private int getBrightness(int x, int y, int z, Vector3ic offset) {
        return this.getBrightness(x += offset.x(), y += offset.y(), z += offset.z());
    }

    private int getBrightness(int x, int y, int z) {
        int index = this.toIndex(x, y, z);
        return this.light[index];
    }

    private boolean shouldSideBeRenderedQuick(RenderBlocks rb, Block block, int x, int y, int z, Facing facing) {
        try {
            return block.func_149646_a(rb.field_147845_a, x + facing.front.x(), y + facing.front.y(), z + facing.front.z(), facing.face.ordinal());
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    private void fetchLightingData(RenderBlocks rb, Block block, int x, int y, int z) {
        for (int xNear = 0; xNear < 3; ++xNear) {
            for (int yNear = 0; yNear < 3; ++yNear) {
                for (int zNear = 0; zNear < 3; ++zNear) {
                    int xOff = x + xNear - 1;
                    int yOff = y + yNear - 1;
                    int zOff = z + zNear - 1;
                    int index = this.toIndex(xNear, yNear, zNear);
                    Block nearBlock = xNear == 1 && yNear == 1 && zNear == 1 ? block : rb.field_147845_a.func_147439_a(xOff, yOff, zOff);
                    this.ao[index] = this.fetchAOAt(rb, nearBlock, xOff, yOff, zOff);
                    this.light[index] = this.fetchLightAt(rb, nearBlock, xOff, yOff, zOff);
                }
            }
        }
        for (Facing.Direction dir : dirs) {
            double inset;
            switch (dir) {
                case FACE_YNEG: {
                    inset = rb.field_147855_j;
                    break;
                }
                case FACE_YPOS: {
                    inset = 1.0 - rb.field_147857_k;
                    break;
                }
                case FACE_ZNEG: {
                    inset = rb.field_147851_l;
                    break;
                }
                case FACE_ZPOS: {
                    inset = 1.0 - rb.field_147853_m;
                    break;
                }
                case FACE_XNEG: {
                    inset = rb.field_147859_h;
                    break;
                }
                case FACE_XPOS: {
                    inset = 1.0 - rb.field_147861_i;
                    break;
                }
                default: {
                    inset = 0.0;
                }
            }
            this.inset[dir.ordinal()] = (float)MathUtil.clamp((double)inset, (double)0.0, (double)1.0);
        }
    }

    private float fetchAOAt(RenderBlocks rb, Block block, int x, int y, int z) {
        return Compat.getAmbientOcclusionLightValue(block, x, y, z, rb.field_147845_a);
    }

    private int fetchLightAt(RenderBlocks rb, Block block, int x, int y, int z) {
        return rb.field_147845_a.func_72802_i(x, y, z, block.getLightValue(rb.field_147845_a, x, y, z));
    }

    private int toIndex(int x, int y, int z) {
        return (z * 3 + y) * 3 + x;
    }

    @Generated
    public AmbientOcclusionRenderer() {
    }
}

