/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.ao;

public final class BrightnessMath {
    private BrightnessMath() {
    }

    public static int lerpBrightness(int a, int b, double fract) {
        int sky = BrightnessMath.lerpBrightnessChannel(BrightnessMath.brightnessSky(a), BrightnessMath.brightnessSky(b), fract);
        int block = BrightnessMath.lerpBrightnessChannel(BrightnessMath.brightnessBlock(a), BrightnessMath.brightnessBlock(b), fract);
        return BrightnessMath.brightnessPack(sky, block);
    }

    public static int biLerpBrightness(int q00, int q10, int q01, int q11, double tx, double ty) {
        int sky = BrightnessMath.biLerpBrightnessChannel(BrightnessMath.brightnessSky(q00), BrightnessMath.brightnessSky(q10), BrightnessMath.brightnessSky(q01), BrightnessMath.brightnessSky(q11), tx, ty);
        int block = BrightnessMath.biLerpBrightnessChannel(BrightnessMath.brightnessBlock(q00), BrightnessMath.brightnessBlock(q10), BrightnessMath.brightnessBlock(q01), BrightnessMath.brightnessBlock(q11), tx, ty);
        return BrightnessMath.brightnessPack(sky, block);
    }

    public static int averageBrightness(int a, int b) {
        int sky = BrightnessMath.averageBrightnessChannel(BrightnessMath.brightnessSky(a), BrightnessMath.brightnessSky(b));
        int block = BrightnessMath.averageBrightnessChannel(BrightnessMath.brightnessBlock(a), BrightnessMath.brightnessBlock(b));
        return BrightnessMath.brightnessPack(sky, block);
    }

    public static int averageBrightness(int a, int b, int c, int d) {
        int sky = BrightnessMath.averageBrightnessChannel(BrightnessMath.brightnessSky(a), BrightnessMath.brightnessSky(b), BrightnessMath.brightnessSky(c), BrightnessMath.brightnessSky(d));
        int block = BrightnessMath.averageBrightnessChannel(BrightnessMath.brightnessBlock(a), BrightnessMath.brightnessBlock(b), BrightnessMath.brightnessBlock(c), BrightnessMath.brightnessBlock(d));
        return BrightnessMath.brightnessPack(sky, block);
    }

    private static int biLerpBrightnessChannel(int q00, int q10, int q01, int q11, double tx, double ty) {
        int x1 = BrightnessMath.lerpBrightnessChannel(q00, q10, tx);
        int x2 = BrightnessMath.lerpBrightnessChannel(q01, q11, tx);
        return BrightnessMath.lerpBrightnessChannel(x1, x2, ty);
    }

    private static int lerpBrightnessChannel(int a, int b, double fract) {
        return (int)((double)a + (double)(b - a) * fract) & 0xFF;
    }

    private static int averageBrightnessChannel(int a, int b) {
        int count = 0;
        int sum = 0;
        if (a != 0) {
            ++count;
            sum += a;
        }
        if (b != 0) {
            ++count;
            sum += b;
        }
        return count == 0 ? 0 : sum / count & 0xFF;
    }

    private static int averageBrightnessChannel(int a, int b, int c, int d) {
        int count = 0;
        int sum = 0;
        if (a != 0) {
            ++count;
            sum += a;
        }
        if (b != 0) {
            ++count;
            sum += b;
        }
        if (c != 0) {
            ++count;
            sum += c;
        }
        if (d != 0) {
            ++count;
            sum += d;
        }
        return count == 0 ? 0 : sum / count & 0xFF;
    }

    private static int brightnessSky(int x) {
        return x & 0xFF;
    }

    private static int brightnessBlock(int x) {
        return (x & 0xFF0000) >>> 16;
    }

    private static int brightnessPack(int sky, int block) {
        return block << 16 | sky;
    }
}

