/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.bsp.sorting.area;

import com.falsepattern.falsetweaks.modules.bsp.sorting.SharedMath;
import com.falsepattern.falsetweaks.modules.bsp.sorting.area.NormalAreaComputer;
import org.joml.Vector3f;

public class QuadAreaComputer
implements NormalAreaComputer {
    public static final QuadAreaComputer INSTANCE = new QuadAreaComputer();

    @Override
    public float getArea(int[] vertexData, int i, int vertexSize, Vector3f buf) {
        float ax = Float.intBitsToFloat(vertexData[i]);
        float ay = Float.intBitsToFloat(vertexData[i + 1]);
        float az = Float.intBitsToFloat(vertexData[i + 2]);
        float bx = Float.intBitsToFloat(vertexData[i + vertexSize]);
        float by = Float.intBitsToFloat(vertexData[i + vertexSize + 1]);
        float bz = Float.intBitsToFloat(vertexData[i + vertexSize + 2]);
        float cx = Float.intBitsToFloat(vertexData[i + vertexSize * 2]);
        float cy = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 1]);
        float cz = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 2]);
        float dx = Float.intBitsToFloat(vertexData[i + vertexSize * 3]);
        float dy = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 1]);
        float dz = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 2]);
        float tri1Area = SharedMath.getTriArea(ax, ay, az, bx, by, bz, cx, cy, cz, buf);
        float tri2Area = SharedMath.getTriArea(ax, ay, az, cx, cy, cz, dx, dy, dz, buf);
        return tri1Area + tri2Area;
    }

    @Override
    public void getNormal(int[] vertexData, int i, int vertexSize, Vector3f output) {
        float ax = Float.intBitsToFloat(vertexData[i]);
        float ay = Float.intBitsToFloat(vertexData[i + 1]);
        float az = Float.intBitsToFloat(vertexData[i + 2]);
        float bx = Float.intBitsToFloat(vertexData[i + vertexSize]);
        float by = Float.intBitsToFloat(vertexData[i + vertexSize + 1]);
        float bz = Float.intBitsToFloat(vertexData[i + vertexSize + 2]);
        float cx = Float.intBitsToFloat(vertexData[i + vertexSize * 2]);
        float cy = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 1]);
        float cz = Float.intBitsToFloat(vertexData[i + vertexSize * 2 + 2]);
        if (ax == bx && ay == by && az == bz || bx == cx && by == cy && bz == cz) {
            bx = cx;
            by = cy;
            bz = cz;
            cx = Float.intBitsToFloat(vertexData[i + vertexSize * 3]);
            cy = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 1]);
            cz = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 2]);
        } else if (ax == cx && ay == cy && az == cz) {
            cx = Float.intBitsToFloat(vertexData[i + vertexSize * 3]);
            cy = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 1]);
            cz = Float.intBitsToFloat(vertexData[i + vertexSize * 3 + 2]);
        }
        SharedMath.getTriangleNormalUnscaled(ax, ay, az, bx, by, bz, cx, cy, cz, output);
        output.normalize();
    }
}

