/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.cubicparticles;

import net.minecraft.client.renderer.Tessellator;

public class ParticleUtil {
    public static void drawCube(Tessellator tess, float pr, float pg, float pb, float u1, float u2, float v1, float v2, float scale, float x, float y, float z) {
        float xp = x + scale;
        float xn = x - scale;
        float yp = y + scale;
        float yn = y - scale;
        float zp = z + scale;
        float zn = z - scale;
        ParticleUtil.setColor(tess, pr, pg, pb, 0.6f);
        ParticleUtil.drawXPos(tess, yn, yp, zn, zp, xp, u1, v1, u2, v2);
        ParticleUtil.drawXNeg(tess, yn, yp, zn, zp, xn, u1, v1, u2, v2);
        ParticleUtil.setColor(tess, pr, pg, pb, 1.0f);
        ParticleUtil.drawYPos(tess, xn, xp, zn, zp, yp, u1, v1, u2, v2);
        ParticleUtil.setColor(tess, pr, pg, pb, 0.5f);
        ParticleUtil.drawYNeg(tess, xn, xp, zn, zp, yn, u1, v1, u2, v2);
        ParticleUtil.setColor(tess, pr, pg, pb, 0.8f);
        ParticleUtil.drawZPos(tess, xn, xp, yn, yp, zp, u1, v1, u2, v2);
        ParticleUtil.drawZNeg(tess, xn, xp, yn, yp, zn, u1, v1, u2, v2);
    }

    private static void setColor(Tessellator tess, float pr, float pg, float pb, float luminosity) {
        tess.func_78386_a(pr * luminosity, pg * luminosity, pb * luminosity);
    }

    private static void drawXPos(Tessellator tessellator, double minY, double maxY, double minZ, double maxZ, double x, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(x, maxY, minZ, u2, v1);
        tessellator.func_78374_a(x, maxY, maxZ, u1, v1);
        tessellator.func_78374_a(x, minY, maxZ, u1, v2);
        tessellator.func_78374_a(x, minY, minZ, u2, v2);
    }

    private static void drawXNeg(Tessellator tessellator, double minY, double maxY, double minZ, double maxZ, double x, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(x, maxY, maxZ, u2, v1);
        tessellator.func_78374_a(x, maxY, minZ, u1, v1);
        tessellator.func_78374_a(x, minY, minZ, u1, v2);
        tessellator.func_78374_a(x, minY, maxZ, u2, v2);
    }

    private static void drawYPos(Tessellator tessellator, double minX, double maxX, double minZ, double maxZ, double y, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(minX, y, maxZ, u2, v1);
        tessellator.func_78374_a(maxX, y, maxZ, u1, v1);
        tessellator.func_78374_a(maxX, y, minZ, u1, v2);
        tessellator.func_78374_a(minX, y, minZ, u2, v2);
    }

    private static void drawYNeg(Tessellator tessellator, double minX, double maxX, double minZ, double maxZ, double y, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(maxX, y, maxZ, u2, v1);
        tessellator.func_78374_a(minX, y, maxZ, u1, v1);
        tessellator.func_78374_a(minX, y, minZ, u1, v2);
        tessellator.func_78374_a(maxX, y, minZ, u2, v2);
    }

    private static void drawZPos(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double z, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(maxX, maxY, z, u2, v1);
        tessellator.func_78374_a(minX, maxY, z, u1, v1);
        tessellator.func_78374_a(minX, minY, z, u1, v2);
        tessellator.func_78374_a(maxX, minY, z, u2, v2);
    }

    private static void drawZNeg(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double z, double u1, double v1, double u2, double v2) {
        tessellator.func_78374_a(minX, maxY, z, u2, v1);
        tessellator.func_78374_a(maxX, maxY, z, u1, v1);
        tessellator.func_78374_a(maxX, minY, z, u1, v2);
        tessellator.func_78374_a(minX, minY, z, u2, v2);
    }
}

