/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.dynlights;

import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayCache<T> {
    private final Class<?> elementClass;
    private final int maxCacheSize;
    private final AbstractObjectList<T> cache;
    private final ReentrantLock MUTEX = new ReentrantLock();

    public ArrayCache(Class<?> elementClass, int maxCacheSize) {
        this.elementClass = elementClass;
        this.maxCacheSize = maxCacheSize;
        this.cache = new ObjectArrayList(maxCacheSize);
    }

    public T allocate(int size) {
        Object arr;
        while (!this.MUTEX.tryLock()) {
            Thread.yield();
        }
        try {
            arr = this.cache.isEmpty() ? null : this.cache.pop();
        }
        finally {
            this.MUTEX.unlock();
        }
        if (arr == null || Array.getLength(arr) < size) {
            arr = Array.newInstance(this.elementClass, size);
        }
        return (T)arr;
    }

    public void free(T arr) {
        if (arr != null) {
            Class<?> cls = arr.getClass();
            if (cls.getComponentType() != this.elementClass) {
                throw new IllegalArgumentException("Wrong component type");
            }
            while (!this.MUTEX.tryLock()) {
                Thread.yield();
            }
            try {
                if (this.cache.size() < this.maxCacheSize) {
                    this.cache.push(arr);
                }
            }
            finally {
                this.MUTEX.unlock();
            }
        }
    }
}

