/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.modules.voxelizer.interfaces.ITextureAtlasSpriteMixin;
import com.falsepattern.lib.util.MathUtil;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class Layer {
    public final TextureAtlasSprite texture;
    public final float thickness;

    private ITextureAtlasSpriteMixin tex() {
        return (ITextureAtlasSpriteMixin)this.texture;
    }

    public int fetchAlpha(int x, int y, int W, int H) {
        x = this.xToReal(x, W);
        y = this.yToReal(y, H);
        if (this.tex().useAnisotropicFiltering()) {
            x += 8;
            y += 8;
        }
        try {
            return this.tex().getFrameAlphaData(this.tex().frameCounter(), x, y);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.texture.func_94215_i());
            throw e;
        }
    }

    private int xToReal(int x, int W) {
        return x / (W / this.tex().getRealWidth());
    }

    private int yToReal(int y, int H) {
        return y / (H / this.tex().getRealHeight());
    }

    public float fetchU(float x, float W) {
        return this.fetch(x, W, this.texture.func_94209_e(), this.texture.func_94212_f());
    }

    public float fetchV(float y, float H) {
        return this.fetch(y, H, this.texture.func_94206_g(), this.texture.func_94210_h());
    }

    private float fetch(float a, float A, float min, float max) {
        return (float)MathUtil.clampedLerp((double)min, (double)max, (double)(a / A));
    }

    public String textureIdentity() {
        return this.texture.func_94215_i() + '|' + this.tex().frameCounter();
    }

    @Generated
    public Layer(TextureAtlasSprite texture, float thickness) {
        this.texture = texture;
        this.thickness = thickness;
    }
}

