/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.modules.voxelizer.Dir;
import com.falsepattern.falsetweaks.modules.voxelizer.Voxel;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelType;

public class VoxelGrid {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    private final byte[] voxels;

    public VoxelGrid(int x, int y, int z) {
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
        this.voxels = new byte[this.xSize * this.ySize * this.zSize];
    }

    public int toIndex(int x, int y, int z) {
        if (x < 0 || x >= this.xSize) {
            return -1;
        }
        if (y < 0 || y >= this.ySize) {
            return -1;
        }
        if (z < 0 || z >= this.zSize) {
            return -1;
        }
        return z * this.ySize * this.xSize + y * this.xSize + x;
    }

    public VoxelType getType(int x, int y, int z) {
        return Voxel.getType(this.voxels[this.toIndex(x, y, z)]);
    }

    public void setType(int x, int y, int z, VoxelType type) {
        this.voxels[this.toIndex((int)x, (int)y, (int)z)] = Voxel.setType(this.voxels[this.toIndex(x, y, z)], type);
    }

    public boolean getFace(int x, int y, int z, Dir dir) {
        return Voxel.getFace(this.voxels[this.toIndex(x, y, z)], dir);
    }

    public void setFace(int x, int y, int z, Dir dir, boolean state) {
        this.voxels[this.toIndex((int)x, (int)y, (int)z)] = Voxel.setFace(this.voxels[this.toIndex(x, y, z)], dir, state);
    }

    public void exchangeFaces(int aIndex, int bIndex, Dir direction) {
        aIndex = aIndex >= this.voxels.length ? -1 : aIndex;
        bIndex = bIndex >= this.voxels.length ? -1 : bIndex;
        byte a = aIndex >= 0 ? this.voxels[aIndex] : (byte)0;
        byte b = bIndex >= 0 ? this.voxels[bIndex] : (byte)0;
        VoxelType aVoxelType = Voxel.getType(a);
        VoxelType bVoxelType = Voxel.getType(b);
        if (aIndex >= 0 && aVoxelType != VoxelType.Transparent && aVoxelType != bVoxelType) {
            this.voxels[aIndex] = Voxel.setFace(a, direction, true);
        }
        if (bIndex >= 0 && bVoxelType != VoxelType.Transparent && aVoxelType != bVoxelType) {
            this.voxels[bIndex] = Voxel.setFace(b, direction.opposite(), true);
        }
    }
}

