/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.modules.voxelizer;

import com.falsepattern.falsetweaks.Share;
import com.falsepattern.falsetweaks.config.VoxelizerConfig;
import com.falsepattern.falsetweaks.modules.voxelizer.Face;
import com.falsepattern.falsetweaks.modules.voxelizer.Layer;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelCompiler;
import com.falsepattern.falsetweaks.modules.voxelizer.VoxelType;
import com.falsepattern.falsetweaks.modules.voxelizer.interfaces.ITextureAtlasSpriteMixin;
import com.falsepattern.falsetweaks.modules.voxelizer.strategy.MergingStrategy;
import com.falsepattern.lib.util.MathUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class VoxelMesh {
    public static final float EPSILON = 1.0E-4f;
    private static final Matrix4fc IDENTITY = new Matrix4f();
    private static final ThreadLocal<Vector3f> workingVector = ThreadLocal.withInitial(Vector3f::new);
    public final float totalThickness;
    private final MergingStrategy strategy;
    private final Layer[] layers;
    private final float[] xOffsets;
    private final float[] yOffsets;
    private final float[] zOffsets;
    private final VoxelCompiler compiler;
    private Map<VoxelType, List<Face>> faceCache;
    private String cacheIdentity = null;

    public VoxelMesh(MergingStrategy strategy, Layer ... layers) {
        this.strategy = strategy;
        this.layers = layers;
        this.compiler = new VoxelCompiler(layers);
        this.xOffsets = new float[this.compiler.xSize + 1];
        this.yOffsets = new float[this.compiler.ySize + 1];
        this.zOffsets = new float[this.compiler.zSize + 1];
        float offset = 0.0f;
        for (int z = this.compiler.zSize - 1; z >= 0; --z) {
            this.zOffsets[z + 1] = offset;
            offset -= layers[z].thickness;
        }
        this.zOffsets[0] = offset;
        this.totalThickness = offset;
        for (int x = 0; x <= this.compiler.xSize; ++x) {
            this.xOffsets[x] = 1.0f - (float)x / (float)this.compiler.xSize;
        }
        for (int y = 0; y <= this.compiler.ySize; ++y) {
            this.yOffsets[y] = 1.0f - (float)y / (float)this.compiler.ySize;
        }
    }

    public static VoxelMesh getMesh(TextureAtlasSprite iicon) {
        ITextureAtlasSpriteMixin texture = (ITextureAtlasSpriteMixin)iicon;
        VoxelMesh mesh = texture.getVoxelMesh();
        if (mesh == null) {
            Layer[] layerArray;
            Layer[] layers = texture.layers();
            MergingStrategy mergingStrategy = VoxelizerConfig.MESH_OPTIMIZATION_STRATEGY_PRESET.strategy;
            if (layers == null) {
                Layer[] layerArray2 = new Layer[1];
                layerArray = layerArray2;
                layerArray2[0] = new Layer(iicon, 0.0625f);
            } else {
                layerArray = layers;
            }
            mesh = new VoxelMesh(mergingStrategy, layerArray);
            texture.setVoxelMesh(mesh);
        }
        return mesh;
    }

    private static void setNormal(Tessellator tess, Vector3f normal) {
        tess.func_78375_b(normal.x, normal.y, normal.z);
    }

    private static void setWorldSpaceLight(Tessellator tess, Vector3f normal) {
        float up = MathUtil.clamp((float)normal.dot(0.0f, 1.0f, 0.0f), (float)0.0f, (float)1.0f);
        float down = MathUtil.clamp((float)normal.dot(0.0f, -1.0f, 0.0f), (float)0.0f, (float)1.0f);
        float northsouth = MathUtil.clamp((float)MathUtil.abs((float)normal.dot(0.0f, 0.0f, 1.0f)), (float)0.0f, (float)1.0f);
        float eastwest = MathUtil.clamp((float)MathUtil.abs((float)normal.dot(1.0f, 0.0f, 0.0f)), (float)0.0f, (float)1.0f);
        float light = Math.max(Math.max(up, 0.5f * down), Math.max(0.8f * northsouth, 0.6f * eastwest));
        tess.func_78386_a(light, light, light);
    }

    private static void setupLighting(Tessellator tess, Vector3f normal, boolean chunkSpace, Matrix4fc transform) {
        transform.transformDirection(normal);
        if (chunkSpace) {
            VoxelMesh.setWorldSpaceLight(tess, normal);
        } else {
            VoxelMesh.setNormal(tess, normal);
        }
    }

    private static void addVertexWithUVWithTransform(Tessellator tess, Vector3f pos, float u, float v, Matrix4fc transform) {
        transform.transformPosition(pos);
        tess.func_78374_a((double)pos.x, (double)pos.y, (double)pos.z, (double)u, (double)v);
    }

    public int xSize() {
        return this.compiler.xSize;
    }

    public int ySize() {
        return this.compiler.ySize;
    }

    public int zSize() {
        return this.compiler.zSize;
    }

    public void renderToTessellator(Tessellator tess, int overlayLayer, boolean remapUV, VoxelType type) {
        this.renderToTessellator(tess, overlayLayer, remapUV, false, IDENTITY, null, type);
    }

    public void renderToTessellator(Tessellator tess, int overlayLayer, boolean remapUV, boolean chunkSpace, Matrix4fc transform, Function<Face, Boolean> trimmingFunction, VoxelType type) {
        this.compile();
        Vector3f vec = workingVector.get();
        for (Face face : this.faceCache.get((Object)type)) {
            float v2;
            float u2;
            float v1;
            float u1;
            if (trimmingFunction != null && trimmingFunction.apply(face).booleanValue()) continue;
            float EPSILON_OUT = (float)overlayLayer * 1.0E-4f;
            if (remapUV) {
                u1 = this.xOffsets[face.minX];
                v1 = this.yOffsets[face.minY];
                u2 = this.xOffsets[face.maxX + 1];
                v2 = this.yOffsets[face.maxY + 1];
            } else {
                u1 = face.u1;
                v1 = face.v1;
                u2 = face.u2;
                v2 = face.v2;
            }
            switch (face.dir) {
                case Front: {
                    VoxelMesh.setupLighting(tess, vec.set(0.0f, 0.0f, 1.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f, this.yOffsets[face.maxY + 1] - 1.0E-4f, this.zOffsets[face.z + 1] + EPSILON_OUT), u1, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f, this.yOffsets[face.minY] + 1.0E-4f, this.zOffsets[face.z + 1] + EPSILON_OUT), u1, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f, this.yOffsets[face.minY] + 1.0E-4f, this.zOffsets[face.z + 1] + EPSILON_OUT), u2, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f, this.yOffsets[face.maxY + 1] - 1.0E-4f, this.zOffsets[face.z + 1] + EPSILON_OUT), u2, v2, transform);
                    break;
                }
                case Back: {
                    VoxelMesh.setupLighting(tess, vec.set(0.0f, 0.0f, -1.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f, this.yOffsets[face.minY] + 1.0E-4f, this.zOffsets[face.z] - EPSILON_OUT), u2, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f, this.yOffsets[face.minY] + 1.0E-4f, this.zOffsets[face.z] - EPSILON_OUT), u1, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f, this.yOffsets[face.maxY + 1] - 1.0E-4f, this.zOffsets[face.z] - EPSILON_OUT), u1, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f, this.yOffsets[face.maxY + 1] - 1.0E-4f, this.zOffsets[face.z] - EPSILON_OUT), u2, v2, transform);
                    break;
                }
                case Left: {
                    VoxelMesh.setupLighting(tess, vec.set(1.0f, 0.0f, 0.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] - 1.0E-4f + EPSILON_OUT, this.yOffsets[face.maxY + 1] - 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] - 1.0E-4f + EPSILON_OUT, this.yOffsets[face.maxY + 1] - 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] - 1.0E-4f + EPSILON_OUT, this.yOffsets[face.minY] + 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] - 1.0E-4f + EPSILON_OUT, this.yOffsets[face.minY] + 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v1, transform);
                    break;
                }
                case Right: {
                    VoxelMesh.setupLighting(tess, vec.set(-1.0f, 0.0f, 0.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] + 1.0E-4f - EPSILON_OUT, this.yOffsets[face.minY] + 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] + 1.0E-4f - EPSILON_OUT, this.yOffsets[face.minY] + 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] + 1.0E-4f - EPSILON_OUT, this.yOffsets[face.maxY + 1] - 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] + 1.0E-4f - EPSILON_OUT, this.yOffsets[face.maxY + 1] - 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v2, transform);
                    break;
                }
                case Up: {
                    VoxelMesh.setupLighting(tess, vec.set(0.0f, 1.0f, 0.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f + EPSILON_OUT, this.yOffsets[face.minY] - 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f + EPSILON_OUT, this.yOffsets[face.minY] - 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u1, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f - EPSILON_OUT, this.yOffsets[face.minY] - 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f - EPSILON_OUT, this.yOffsets[face.minY] - 1.0E-4f + EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u2, v1, transform);
                    break;
                }
                case Down: {
                    VoxelMesh.setupLighting(tess, vec.set(0.0f, -1.0f, 0.0f), chunkSpace, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f - EPSILON_OUT, this.yOffsets[face.maxY + 1] + 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u2, v1, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.maxX + 1] - 1.0E-4f - EPSILON_OUT, this.yOffsets[face.maxY + 1] + 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u2, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f + EPSILON_OUT, this.yOffsets[face.maxY + 1] + 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z] - 1.0E-4f - EPSILON_OUT), u1, v2, transform);
                    VoxelMesh.addVertexWithUVWithTransform(tess, vec.set(this.xOffsets[face.minX] + 1.0E-4f + EPSILON_OUT, this.yOffsets[face.maxY + 1] + 1.0E-4f - EPSILON_OUT, this.zOffsets[face.z + 1] + 1.0E-4f + EPSILON_OUT), u1, v1, transform);
                }
            }
        }
    }

    public void compile() {
        String currentIdentity = this.getIdentity(0, false);
        if (!Objects.equals(this.cacheIdentity, currentIdentity)) {
            if (VoxelizerConfig.DEBUG_MESH_COMPILATION) {
                Share.log.info("Starting compilation for mesh \"" + currentIdentity + "\"");
            }
            this.faceCache = this.compiler.compile(this.strategy);
            if (VoxelizerConfig.DEBUG_MESH_COMPILATION) {
                Share.log.info("Compiled mesh \"" + currentIdentity + "\" with " + this.faceCache.size() + " faces!");
            }
            this.cacheIdentity = currentIdentity;
        }
    }

    public String getIdentity(int overlayLayer, boolean remapUV) {
        StringBuilder result = new StringBuilder();
        if (remapUV) {
            result.append("remap_uv!");
        }
        if (overlayLayer > 0) {
            result.append("overlay").append(overlayLayer).append("!");
        }
        for (Layer layer : this.layers) {
            result.append(layer.textureIdentity()).append('&');
        }
        return result.toString();
    }
}

