/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates;

import com.falsepattern.lib.asm.ASMUtil;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Threading_RenderBlocksASM
implements TurboClassTransformer {
    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_RenderBlocksASM";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        return "net.minecraft.client.renderer.RenderBlocks".equals(className);
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        this.transformRenderBlockByRenderType(cn);
        return true;
    }

    private void transformRenderBlockByRenderType(ClassNode cn) {
        MethodNode method = ASMUtil.findMethodFromMCP((ClassNode)cn, (String)"renderBlockByRenderType", (String)"(Lnet/minecraft/block/Block;III)Z", (boolean)false);
        ListIterator list = method.instructions.iterator();
        boolean found = false;
        while (list.hasNext()) {
            VarInsnNode varInsn;
            AbstractInsnNode insn = (AbstractInsnNode)list.next();
            if (!(insn instanceof VarInsnNode) || (varInsn = (VarInsnNode)insn).getOpcode() != 54 || varInsn.var != 5) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Could not find injection point!");
        }
        list.add(new VarInsnNode(25, 0));
        list.add(new VarInsnNode(25, 1));
        list.add(new VarInsnNode(21, 5));
        list.add(new MethodInsnNode(183, "net/minecraft/client/renderer/RenderBlocks", "ft$cancelRenderDelegatedToDifferentThread", "(Lnet/minecraft/block/Block;I)I", false));
        LabelNode lbl = new LabelNode();
        list.add(new InsnNode(89));
        list.add(new JumpInsnNode(153, lbl));
        list.add(new InsnNode(4));
        list.add(new InsnNode(100));
        list.add(new InsnNode(172));
        list.add(lbl);
        list.add(new FrameNode(4, 0, null, 1, new Object[]{"I"}));
        list.add(new InsnNode(87));
    }
}

