/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.falsetweaks.asm.modules.threadedupdates;

import com.falsepattern.falsetweaks.config.ThreadingConfig;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Threading_TessellatorUseReplacement
implements TurboClassTransformer {
    private static final String TARGET_DESC_NOTCH = "Lbmh;";
    private static final String TARGET_DESC_SRG = "Lnet/minecraft/client/renderer/Tessellator;";
    private static final String REPLACEMENT_OWNER = "com/falsepattern/falsetweaks/api/ThreadedChunkUpdates";
    private static final String REPLACEMENT_NAME = "getThreadTessellator";
    private static final String REPLACEMENT_DESC = "()Lnet/minecraft/client/renderer/Tessellator;";
    private static final Set<String> CLASS_NAMES = new HashSet<String>();
    private static final List<String> PREFIXES = new ArrayList<String>();
    private static final boolean REPLACE_EVERYTHING;
    private static final String[] REPLACE_EVERYTHING_WHITELIST;
    private static final String[] HARDCODED;

    public static void addAll(String ... names) {
        for (String targetName : names) {
            if (!targetName.endsWith("*")) {
                CLASS_NAMES.add(targetName);
                continue;
            }
            PREFIXES.add(targetName.substring(0, targetName.length() - 1));
        }
    }

    public String owner() {
        return "FalseTweaks";
    }

    public String name() {
        return "Threading_TessellatorUseReplacement";
    }

    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (REPLACE_EVERYTHING) {
            for (String entry : REPLACE_EVERYTHING_WHITELIST) {
                if (!className.startsWith(entry)) continue;
                return false;
            }
            return true;
        }
        if (CLASS_NAMES.contains(className)) {
            return true;
        }
        for (String prefix : PREFIXES) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        boolean modified = false;
        List methods = cn.methods;
        for (MethodNode classMethod : methods) {
            ListIterator insnList = classMethod.instructions.iterator();
            while (insnList.hasNext()) {
                int opcode;
                AbstractInsnNode insn = (AbstractInsnNode)insnList.next();
                if (!(insn instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldInst = (FieldInsnNode)insn;
                if (!TARGET_DESC_NOTCH.equals(fieldInst.desc) && !TARGET_DESC_SRG.equals(fieldInst.desc) || (opcode = insn.getOpcode()) != 180 && opcode != 178) continue;
                insnList.add(new InsnNode(87));
                insnList.add(new MethodInsnNode(184, REPLACEMENT_OWNER, REPLACEMENT_NAME, REPLACEMENT_DESC, false));
                modified = true;
            }
        }
        return modified;
    }

    static {
        REPLACE_EVERYTHING_WHITELIST = new String[]{"com.falsepattern.falsetweaks."};
        HARDCODED = new String[]{"appeng.client.render.*", "appeng.facade.FacadePart", "appeng.parts.*", "binnie.extratrees.block.DoorBlockRenderer", "biomesoplenty.client.render.blocks.*", "buildcraft.core.render.RenderingMarkers", "buildcraft.silicon.render.RenderLaserTable", "buildcraft.transport.render.PipeRendererWorld", "codechicken.lib.render.CCRenderState", "com.carpentersblocks.renderer.*", "com.enderio.core.client.render.*", "com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture", "com.github.technus.tectech.util.LightingHelper", "com.hbm.render.block.*", "com.jaquadro.minecraft.storagedrawers.util.*", "com.rwtema.extrautils.block.render.*", "com.thecodewarrior.catwalks.render.*", "crazypants.enderio.conduit.*", "crazypants.enderio.machine.*", "extracells.part.PartECBase", "extracells.render.block.RendererHardMEDrive$", "flaxbeard.thaumicexploration.client.render.BlockEverfullUrnRenderer", "forestry.apiculture.render.RenderCandleBlock", "forestry.core.render.*", "gcewing.architecture.BaseWorldRenderTarget", "gregapi.old.GT_RenderUtil", "gregapi.render.*", "gregtech.GT_Client", "gregtech.api.objects.GT_RenderedTexture", "gregtech.api.util.LightingHelper", "gregtech.common.render.GT_Renderer_Block", "ic2.core.block.RenderBlockCrop", "lotr.client.render.*", "lumien.randomthings.Client.Renderer.RenderWirelessLever", "mods.natura.client.LeverRender", "mods.natura.client.SaguaroRenderer", "mods.railcraft.client.render.RenderFakeBlock", "net.malisis.core.renderer.MalisisRenderer", "net.minecraft.client.renderer.RenderBlocks", "net.minecraftforge.fluids.RenderBlockFluid", "openmods.renderer.FixedRenderBlocks", "openmods.renderer.TweakedRenderBlocks", "tb.client.render.block.ThaumicRelocatorRenderer", "team.chisel.ctmlib.*", "thaumcraft.client.renderers.block.*", "thaumic.tinkerer.client.render.block.kami.RenderWarpGate", "thaumicenergistics.client.render.RenderBlockProviderBase", "thaumicenergistics.common.parts.ThEPartBase", "tuhljin.automagy.renderers.RenderBlockGlowOverlay", "twilightforest.client.renderer.blocks.RenderBlockTFCastleMagic", "vswe.stevescarts.Renders.RendererUpgrade", "vswe.stevesfactory.blocks.RenderCamouflage"};
        Threading_TessellatorUseReplacement.addAll(HARDCODED);
        Threading_TessellatorUseReplacement.addAll(ThreadingConfig.TESSELLATOR_USE_REPLACEMENT_TARGETS);
        REPLACE_EVERYTHING = ThreadingConfig.TESSELLATOR_REPLACE_EVERYTHING;
    }
}

